<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "common/db/issues.php" );
require_once( "common/db/task.php" );
require_once( "common/db/summary.php" );

require_once( "common/mst/common.php" );

class Task_IndexController extends Ext_Controller_Action
{

    public function init(){

        if( $this->isNotLogin() ) return;
        if( $this->isNotSelectProject() ) return;

        $subMenu = array();
        $subMenu["100"]["href"] = MVC_HOME. "task/ref/myview?uid=". usess_get_userid();
        $subMenu["100"]["name"] = t( "My Task" );

        $this->view->assign( "sub_menu", $subMenu );

        $mst = array();

        $mst['task_status'] = mst_task_status();
        $users              = array( "" => "ALL") + mst_users( false );
        $mst['users']       = $users;

        $this->view->assign( "m", $mst );
    }

    public function indexAction(){
        // action body
        $session = Zend_Registry::get( "sess" );
        $session->task_myview_summary_status = 1300;

        $this->_redirect( "task/ref/myview?uid=". usess_get_userid() );
    }


}