<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

require_once( "common/db/project.php" );

class System_ProjectController extends System_IndexController
{

	public function extValidate( $name, $value, $action, $request ){

		switch( $action )
		{
			case "editconfirm":
			case "complete":

				if( $name == "start_date" || $name == "end_date" )
				{
					$ret = array();
					if( ! checkdate( intval( $value['M'] ), intval( $value['D'] ), intval( $value['Y'] ) ) )
					{
						$ret[] = "invalid date";
						return $ret;
					}
				}

				break;
			default:
		}

		return true;
	}


    public function indexAction(){
        // action body

    	if( conf_is_singleproject() )
    	{
    		$this->_forward( "detail", null, null, array( "id" => usess_selected_project() ) );
    		return;
    	}

        $this->_forward( "list" );
    }

    public function addAction(){

        $this->view->assign( "nextaction", "editconfirm" );
        $this->view->assignLang( "pagename", "Add project" );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );
    }

    public function listAction(){

        $req = $this->getRequest()->getParams();

        $paginator = db_project_list();

        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( 10 );

        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "datalist" , $arItem->getArrayCopy() );

        $this->view->assignLang( "totalcount", "%s projects", $paginator->getTotalItemCount() );
        $this->view->assignLang( "pagename" , "list of projects" );

    }


    public function detailAction(){
        // action body
        $this->view->assignLang( "pagename" , t( "Project information" ) );

        $req = $this->getRequest()->getParams();
        $arProject = db_project_one( $req['id'] );

        $this->view->assignRequest( $arProject );
    }

    public function editAction(){

    	$this->view->assign("nextaction", "editconfirm" );

        // action body
        $this->view->assignLang( "pagename" , t( "Project information" ) );

        $req = $this->getRequest()->getParams();

        $arProject = db_project_one( $req['id'] );
        $sd = $arProject['start_date'];
        $ed = $arProject['end_date'];
        $arProject["start_date"] = array();
        $arProject["start_date"]["Y"] = date( "Y", strtotime( $sd ) );
        $arProject["start_date"]["M"] = date( "m", strtotime( $sd ) );
        $arProject["start_date"]["D"] = date( "d", strtotime( $sd ) );

        $arProject["end_date"] = array();
        $arProject["end_date"]["Y"] = date( "Y", strtotime( $ed ) );
        $arProject["end_date"]["M"] = date( "m", strtotime( $ed ) );
        $arProject["end_date"]["D"] = date( "d", strtotime( $ed ) );

        $this->view->assignRequest( array_merge( $arProject, $req ) );

    }

    public function editconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/project.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->project->regist );

        // action body
        $this->view->assignLang( "pagename" , t( "Project information" ) );

        $this->view->assignRequest( $arProject );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "start_date", "end_date" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "edit" );
            return;
        }

        $this->view->assign("nextaction", "complete" );
    }

    public function completeAction(){

        $config = new Zend_Config_Ini( "common/validation/project.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->project->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "start_date", "end_date" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "edit" );
            return;
        }

        // regist database

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"project", "db"=>$db ) );


        $data = array(
            'name'         => $req['name'],
            'description'  => $req['description'],
            'start_date'   => sprintf( '%s-%s-%s 00:00:00', $req['start_date']["Y"], $req['start_date']["M"], $req['start_date']["D"] ),
            'end_date'     => sprintf( '%s-%s-%s 00:00:00', $req['end_date']["Y"], $req['end_date']["M"], $req['end_date']["D"] ),
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );
        }
        else
        {
        	$data['status'] = 1;
        	$data['enabled'] = 1;

            $table->insert( $data );
        }

        $id = $db->lastInsertId();

        $this->render( "complete" );
    }




}