<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

require_once( "common/db/phenomenontypes.php" );

require_once( "Zend/Paginator.php" );
require_once( "Zend/Paginator/Adapter/Array.php" );
require_once( "Zend/Paginator/ScrollingStyle/Sliding.php" );
require_once( "Zend/View/Helper/PaginationControl.php" );

class System_PhenomenontypesController extends System_IndexController
{

	public function extValidate( $name, $value, $action, $request ){

		switch( $action )
		{
			case "editconfirm":
			case "complete":

				break;
			default:
		}

		return true;
	}


    public function indexAction(){
        // action body
        $this->_forward( "list" );
    }

    public function listAction(){
        // action body
        $this->view->assignLang( "pagename" , t( "Phenomenon types" ) );

        $req = $this->getRequest()->getParams();

        $this->view->assign( "list" , db_phenomenontypes_list( $req['disabled']=="1" ? false : true ) );

        $this->view->assignRequest( $req );
    }

    public function addAction(){

//    	$req = $this->getRequest();
//        $req->setParam( "project_id", $req['project_id'] );
//        $this->setRequest( $req );

    	$this->view->assignLang( "pagename" , t( "Phenomenon regist" ) );
    	$this->view->assignLang( "nextaction" , "confirm" );

    	$req = $this->getRequest()->getParams();


    	$this->view->assignRequest( $req );
    }

    public function editAction(){

        $req = $this->getRequest()->getParams();

        $row = db_phenomenontypes_one( $req['id'] );

        $this->view->assign( "nextaction", "editconfirm" );
        $this->view->assignLang( "pagename", "Edit phenomenon" );

        $d = array(
            "name"        => $row['name'],
            "description" => $row['description'],
            "enabled"     => $row['enabled']
        );

        $this->view->assignRequest( array_merge($d, $req ) );

    }

    public function confirmAction(){

        $config = new Zend_Config_Ini( "common/validation/phenomenontypes.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "enabled" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        $this->view->assign( "nextaction", "complete" );
    }

    public function editconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/phenomenontypes.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "enabled" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "edit" );
            return;
        }

        $this->view->assign( "nextaction", "editcomplete" );
    }

    public function completeAction(){

        $config = new Zend_Config_Ini( "common/validation/phenomenontypes.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "enabled" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        // regist database

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"phenomenons", "db"=>$db ) );

        $data = array(
            'name'          => $req['name'],
            'description'   => $req['description'],
            'enabled'       => $req['enabled'],
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );
        }
        else
        {
            // additional columns
            $data['order_rank'] = time();

            $table->insert( $data );
        }
        $cid = $db->lastInsertId();

        $this->view->assign( "cid", $cid );

        $this->render( "complete" );
    }

    public function editcompleteAction(){

        $this->completeAction();
    }



}