<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

require_once( "common/db/categories.php" );
require_once( "common/db/project.php" );

require_once( "Zend/Paginator.php" );
require_once( "Zend/Paginator/Adapter/Array.php" );
require_once( "Zend/Paginator/ScrollingStyle/Sliding.php" );
require_once( "Zend/View/Helper/PaginationControl.php" );

class System_CategoriesController extends System_IndexController
{

	public function extValidate( $name, $value, $action, $request ){

		switch( $action )
		{
			case "editconfirm":
			case "complete":

				break;
			default:
		}

		return true;
	}


    public function indexAction(){
        // action body
    	if( conf_is_singleproject() )
        {
            $this->_forward( "list", null, null, array( "project_id" => usess_selected_project() ) );
            return;
        }

    	$this->_forward( "projectselect" );
    }

    public function projectselectAction(){

        $req = $this->getRequest()->getParams();

        $paginator = db_project_list();

        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( 10 );

        $paginator->setView( $this->view );

        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "datalist" , $arItem->getArrayCopy() );

        $this->view->assignLang( "totalcount", "%s projects", $paginator->getTotalItemCount() );
        $this->view->assignLang( "pagename" , "Manage Categories" );

    }

    public function listAction(){
        // action body
        $this->view->assignLang( "pagename" , t( "Project categories" ) );

        $req = $this->getRequest()->getParams();

        $this->view->assign( "list" , db_categories_list( $req['project_id'], $req['disabled']=="1" ? false : true ) );

        $this->view->assignRequest( $req );
    }

    public function addAction(){

//    	$req = $this->getRequest();
//        $req->setParam( "project_id", $req['project_id'] );
//        $this->setRequest( $req );

    	$this->view->assignLang( "pagename" , t( "Category regist" ) );
    	$this->view->assignLang( "nextaction" , "confirm" );

    	$req = $this->getRequest()->getParams();


    	$this->view->assignRequest( $req );
    }

    public function editAction(){

        $req = $this->getRequest()->getParams();

        $row = db_category_one( $req['cid'] );

        $this->view->assign( "nextaction", "editconfirm" );
        $this->view->assignLang( "pagename", "Edit category" );

        $d = array(
            "project_id"  => $row['project_id'],
            "name"        => $row['name'],
            "description" => $row['description'],
            "enabled"     => $row['enabled']
        );

        $this->view->assignRequest( array_merge($d, $req ) );

    }

    public function confirmAction(){

        $config = new Zend_Config_Ini( "common/validation/categories.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->categories->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "enabled" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        $this->view->assign( "nextaction", "complete" );
    }

    public function editconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/categories.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->categories->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "enabled" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "edit" );
            return;
        }

        $this->view->assign( "nextaction", "editcomplete" );
    }

    public function completeAction(){

        $config = new Zend_Config_Ini( "common/validation/categories.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->categories->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "name", "description", "enabled" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        // regist database

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"categories", "db"=>$db ) );


        $data = array(
            'project_id'    => $req['project_id'],
            'name'          => $req['name'],
            'description'   => $req['description'],
            'enabled'       => $req['enabled'],
        );

        if( $req['cid'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['cid'] );
            $table->update( $data, $where );
        }
        else
        {
            // additional columns
            $data['order_rank'] = time();

            $table->insert( $data );
        }
        $cid = $db->lastInsertId();

        $this->view->assign( "cid", $cid );

        $this->render( "complete" );
    }

    public function editcompleteAction(){

        $this->completeAction();
    }



}