<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class Meeting_RegistController extends Meeting_IndexController
{

    public function extValidate( $name, $value, $action, $request ){

        switch( $action )
        {
            case "confirm":

                if( $name == "open_date" )
                {
                    $ret = array();
                    if( ! checkdate( intval( $value['M'] ), intval( $value['D'] ), intval( $value['Y'] ) ) )
                    {
                        $ret[] = "invalid date";
                        return $ret;
                    }
                }

                break;
            default:
        }

        return true;
    }


    public function indexAction(){
        // action body
        $this->_forward( "addissue" );
    }

    public function addissueAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Choose Issues" );
        $this->view->assign( "includescript", array( "meeting.addissue.js" ) );
        $this->view->assign( "nextaction", "addbase" );

        $paginator = db_issues_list( usess_selected_project( ) );

        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 10000 );

        $issue_list = $paginator->getCurrentItems();

        $this->view->assign( "issue_list", (array) $issue_list );

        $handlers = array();
        foreach( $issue_list as $eachIssue )
        {
        	$issueHandlers = db_issues_handler( $eachIssue['id'] );
        	foreach( $issueHandlers as $eachIssueHandler )
        	{
	        	$handlers[ $eachIssue['id'] ][] = $eachIssueHandler["user_id"];
        	}
        }

        $d = array();
        $d["selected_issue"] = array();
        $d["open_date"] = db_common_convdate( $req['open_date'], date_explode( ) );
        $d["project_id"] = usess_selected_project();

        $this->view->assign( "handlers", $handlers );
        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function editissueAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Choose Issues" );
        $this->view->assign( "includescript", array( "meeting.addissue.js" ) );
        $this->view->assign( "nextaction", "editissuecomplete" );

        $infoItem = array();
        $infoItem["1"]["data"] = "ミーティング詳細";
        $infoItem["1"]["href"] = MVC_HOME. "meeting/ref/issues?id=". $req['id'] ;

        $this->view->assign( "info_item", $infoItem );

        $paginator = db_meeting_issues( $req['id'] );

        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 10000 );

        $selected_issue_list = $paginator->getCurrentItems();

        $arSelectedId = array();
        foreach( $selected_issue_list as $eachIssue )
        {
        	$arSelectedId[] = $eachIssue['issue_id'];
        }

        $paginator = db_issues_list( usess_selected_project( ) );

        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 10000 );

        $issue_list = $paginator->getCurrentItems();

//        foreach( $issue_list as $key => $val )
//        {
//        	if( in_array( $val['id'], $arSelectedId ) )
//        	{
//        		unset( $issue_list[$key] );
//        	}
//        }

        $this->view->assign( "selected_issue_list", $arSelectedId );
        $this->view->assign( "issue_list", (array) $issue_list );

        $handlers = array();
        foreach( $issue_list as $eachIssue )
        {
        	$issueHandlers = db_issues_handler( $eachIssue['id'] );
        	foreach( $issueHandlers as $eachIssueHandler )
        	{
	        	$handlers[ $eachIssue['id'] ][] = $eachIssueHandler["user_id"];
        	}
        }

        $d = array();
        $d["selected_issue"] = array();
        $d["open_date"] = db_common_convdate( $req['open_date'], date_explode( ) );
        $d["project_id"] = usess_selected_project();

        $this->view->assign( "handlers", $handlers );
        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function addbaseAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting Information" );
        $this->view->assign( "nextaction", "confirm" );

        $d = array();
        $d["open_date"] = db_common_convdate( $req['open_date'], date_explode( ) );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function editbaseAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting Information" );
        $this->view->assign( "nextaction", "editconfirm" );

        $d = db_meeting_one( $req['id'] );
        $d["start_time"] = db_common_convtime( $d['start_time'] );
        $d["end_time" ]  = db_common_convtime( $d['end_time']   );
        $d["open_date"]  = db_common_convdate( $d['open_date'] , date_explode( ) );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function resulteditAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting Detail" );
        $this->view->assign( "includescript", array( "meeting.resultedit.js" ) );
        $this->view->assign( "nextaction", "resulteditcomplete" );
        $d = array();

        $paginator = db_meeting_issues( $req['id'] );
        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 300 );

        $this->view->assign( "meeting", db_meeting_one( $req['id'] ) );
        $this->view->assign( "issues" , $paginator->getCurrentItems()->getArrayCopy() );
        $this->view->assign( "tasks"  , db_meeting_tasks( $req['id'] ) );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function confirmAction(){

        $this->view->assignLang( "pagename" , "Meeting Information" );

        $config = new Zend_Config_Ini( "common/validation/meeting.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "title", "open_date", "start_time", "end_time", "location", "description", "selected_issue" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "addbase" );
            return;
        }

        $this->view->assign( "nextaction", "complete" );
    }

    public function editconfirmAction(){

        $this->view->assignLang( "pagename" , "Meeting Information" );

        $config = new Zend_Config_Ini( "common/validation/meeting.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "title", "open_date", "start_time", "end_time", "location", "description", "selected_issue" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "addbase" );
            return;
        }

        $this->view->assign( "nextaction", "complete" );
    }

    public function completeAction(){

        $this->view->assignLang( "pagename" , "Meeting Information" );

        $config = new Zend_Config_Ini( "common/validation/meeting.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "open_date", "start_time", "end_time", "location", "description", "selected_issue" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
        	throw new Exception();
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"meetings", "db"=>$db ) );

        $data = array(
            'project_id'        => $req['project_id'],
            'title'             => $req['title'],
            'open_date'         => db_common_convdate( $req['open_date'] ),
            'start_time'        => db_common_convtime( $req['start_time'] ),
            'end_time'          => db_common_convtime( $req['end_time'] ),
            'description'       => $req['description'],
            'location'          => $req['location'],
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );

	        $this->view->assignRequest( $req );
	        $this->render( "editcomplete" );
	        return;
        }
        else
        {
        	$data['status'] = 1100;

            $table->insert( $data );
            $meetingId = $db->lastInsertId();

            $issuesTable = new Ext_Db_Table( array( "name"=>"meeting_issues", "db"=>$db ) );
            foreach( $req['selected_issue'] as $eachIssueId )
            {
            	$issueData = array(
            	   'issue_id'      => $eachIssueId,
            	   'meeting_id'    => $meetingId
            	);

            	$issuesTable->insert( $issueData );
            }
        }


        $this->render( "complete" );
    }

    public function editissuecompleteAction(){

    	$this->view->assignLang( "pagename" , "Meeting Information" );

        $config = new Zend_Config_Ini( "common/validation/meeting.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "open_date", "start_time", "end_time", "location", "description", "selected_issue" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            throw new Exception();
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

    	$issuesTable = new Ext_Db_Table( array( "name"=>"meeting_issues", "db"=>$db ) );
    	foreach( $req['selected_issue'] as $eachIssueId )
    	{
    		$issueData = array(
                   'issue_id'      => $eachIssueId,
                   'meeting_id'    => $req['id']
    		);

    		$issuesTable->insert( $issueData );
    	}

    	$this->view->assignRequest( $req );
    	$this->render( "editcomplete" );
    }

    public function resulteditcompleteAction(){

        $this->view->assignLang( "pagename" , "Meeting Information" );

        $config = new Zend_Config_Ini( "common/validation/meeting.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "result_description" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            throw new Exception();
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $issuesTable = new Ext_Db_Table( array( "name"=>"meeting_issues", "db"=>$db ) );

        foreach( $req['result_description'] as $issueId => $eachResultDescription )
        {
            $issueData = array(
                   'result_description'    => $eachResultDescription
            );

            $where = $db->quoteInto( "id=?", $issueId );

            $issuesTable->update( $issueData, $where );
        }

        $this->view->assignRequest( $req );
        $this->render( "editcomplete" );

    }

    public function deleteissueAction(){

    	$req = $this->getRequest()->getParams();

        // regist database
        $db = DBLOADER::getApp();

        $db->delete( 'meeting_issues', 'meeting_id= '.$req['id']. ' AND issue_id= '. $req['issue_id'] );

    	$this->_redirect( '/meeting/ref/issues?id='. $req['id'] );
    }

}