<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class Meeting_RefController extends Meeting_IndexController
{

    public function indexAction(){
        // action body
        $this->_forward( "top" );
    }

    public function topAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting TOP" );

        $paginator = db_meeting_list( usess_selected_project() );
        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 300 );

        $arItem = $paginator->getCurrentItems()->getArrayCopy();

        $cal = cal_weeks( firstday_of_week( strtotime("last week")) );

        $arMtg = array();
        foreach( $arItem as $eachMtg )
        {
        	foreach( $cal as $eachTS )
        	{
        		if( date("Y-m-d", $eachTS ) == date("Y-m-d", strtotime( $eachMtg['open_date'] ) ) )
        		{
        			$arMtg[$eachTS][] = $eachMtg;
        		}
        		continue ;
        	}
        }

        $this->view->assign( "cal", $cal );

        $this->view->assign( "mtg", $arMtg );
    }

    public function historyAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting History" );

        $paginator = db_meeting_list( usess_selected_project() );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( 20 );

        $this->view->assign( "paginator", (array) $paginator->getPages() );
        $arItem = $paginator->getCurrentItems()->getArrayCopy();

        $this->view->assign( "mtg", $arItem );
    }

    public function detailAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting Detail" );

        $d = db_meeting_one( $req['id'] );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function issuesAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting Detail" );
        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_meeting_issues( $req['id'] );
        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 300 );

        $d['issues'] = $paginator->getCurrentItems()->getArrayCopy();

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function printAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Meeting Detail" );
        $d = array();

        $paginator = db_meeting_issues( $req['id'] );
        $paginator->setCurrentPageNumber( 1 );
        $paginator->setItemCountPerPage( 300 );

        $this->view->assign( "meeting", db_meeting_one( $req['id'] ) );
        $this->view->assign( "issues" , $paginator->getCurrentItems()->getArrayCopy() );
        $this->view->assign( "tasks"  , db_meeting_tasks( $req['id'] ) );

        $this->view->assignRequest( array_merge($d, $req ) );
    }
}