<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class Issue_RegistController extends Issue_IndexController
{

    public function indexAction(){
        // action body
        $this->_forward( "add" );
    }

    public function extValidate( $name, $value, $action, $request ){

        switch( $action )
        {
            case "starteditconfirm":
            case "confirm":
            case "editconfirm":

            	if( $name == "deadline" && $value['M'] == "" && $value['D'] == "" && $value['Y'] == "" )
            	{
            		if( conf_issuedeadline_required() )
            		{
                        $ret[] = "invalid date";
                        return $ret;
            		}

            		return "skip";
            	}

            	if( $name == "start_date" || $name == "deadline" )
                {
                    $ret = array();
                    if( ! checkdate( intval( $value['M'] ), intval( $value['D'] ), intval( $value['Y'] ) ) )
                    {
                        $ret[] = "invalid date";
                        return $ret;
                    }
                }

            	break;

            default:
        }

        return true;
    }

    public function getBackMode( $mode ){

    	switch( $mode )
    	{
    		case "finished":
    		case "progress":
    		case "myissue":
    		case "finished":
    		case "approved":
    			$ret = $mode;
    			break;

    		case "newarrive":
    		default:
    			$mode = "newarrive";
    	}

    	return $mode;
    }

    public function terminateAction(){

        $req = $this->getRequest()->getParams();

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"issues", "db"=>$db ) );

        $data = array(
            'status'        => 1900,
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );

	        /* Finish tasks */
	        db_tasks_finish_all( $req['id'] );
        }


        $this->render( "complete" );
    }


    public function withdrawAction(){

        $req = $this->getRequest()->getParams();

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"issues", "db"=>$db ) );

        $data = array(
            'status'        => 1100,
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );
        }

        $this->render( "complete" );
    }


    public function addAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , t("Add Issue") );
        $this->view->assign("nextaction", "confirm" );

        $d['project_id'] = usess_selected_project();
        $d['priority'] = 500;
        $d['severity'] = 100;
        $d['scale']    = 500;
        $d['categories'] = array();

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function editAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Edit issue" );
        $this->view->assign( "nextaction", "editconfirm" );

        $d = db_issues_one( $req['id'] );
        $tmpCat = db_issue_categories( $req['id'] );

        $d['categories'] = array();
        foreach( $tmpCat as $eachCategory )
        {
        	$d['categories'][ $eachCategory['category_id'] ] = $eachCategory['category_id'];
        }

        $d["deadline"]   = db_common_convdate( $d['deadline'] );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function confirmAction(){

        $config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );
        $this->view->assignLang( "pagename" , t("Add Issue") );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "title", "description", "phenomenon_type", "priority", "severity", "deadline" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        $this->view->assign( "nextaction", "complete" );
    }

    public function editconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "title", "description", "phenomenon_type", "priority", "severity", "deadline" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "edit" );
            return;
        }

        $this->view->assign( "nextaction", "editcomplete" );
    }

    public function completeAction(){

        $config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "title", "description", "phenomenon_type", "priority", "severity", "deadline" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"issues", "db"=>$db ) );

        $data = array(
            'project_id'        => $req['project_id'],
            'title'             => $req['title'],
            'description'       => $req['description'],
            'phenomenon_type'   => $req['phenomenon_type'],
            'priority'          => $req['priority'],
            'severity'          => $req['severity'],
            'deadline'          => db_common_convdate( $req['deadline'] ),
            'scale'             => $req['scale'],
            'registed'          => db_common_now( $db )
        );

        $tableCategory = new Ext_Db_Table( array( "name"=>"issue_categories", "db"=>$db ) );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );

            $where = $tableCategory->getAdapter()->quoteInto( 'issue_id=?', $req['id'] );
            $tableCategory->delete( $where );
            $issue_id = $req['id'];
        }
        else
        {
            // additional columns
            $data['ver']        = 1;
            $data['issue_type'] = 1;
            $data['status']     = "1100";

            $table->insert( $data );
            $issue_id = $db->lastInsertId();



        }

        $cdata = array();
        if( is_array( $req['categories'] ) ) foreach( $req['categories'] as $eachCategoryID )
        {
        	$cdata['issue_id'] = $issue_id;
        	$cdata['category_id'] = $eachCategoryID;

        	$tableCategory->insert( $cdata );
        }

        $this->view->assign( "backmode", $this->getBackMode( $req['backmode'] ) );
        $this->render( "complete" );
    }

    public function editcompleteAction(){

        $this->completeAction();
    }

    public function starteditAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Start Issue" );
        $this->view->assign( "nextaction", "starteditconfirm" );

        $d = db_issues_one( $req['id'] );
        $d["start_date"] = db_common_convdate( $d['start_date'], date_explode( ) );
        $d["deadline"]   = db_common_convdate( $d['deadline'] );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function starteditconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $this->view->assignLang( "pagename" , "Start Issue" );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "start_date", "deadline", "estimate", "description" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "startedit" );
            return;
        }

        $this->view->assign( "nextaction", "starteditcomplete" );
    }

    /**
     *
     *
     */
    public function starteditcompleteAction(){

        $config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "start_date", "deadline", "estimate", "description" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "startedit" );
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"issues", "db"=>$db ) );

        $data = array(
            'start_date'        => db_common_convdate( $req['start_date'] ),
            'deadline'          => db_common_convdate( $req['deadline']   ),
            'description'       => $req['description'],
            'estimate'          => $req['estimate'],
            'status'            => "1300"
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );

            $handlerData  = array(
                "issue_id" => $req['id']
            );
            foreach( $req['handler'] as $eachHandler )
            {
            	$handlerTable = new Ext_Db_Table( array( "name" => "handleuser", "db" => $db ) );

            	$where = $handlerTable->getAdapter()->quoteInto( 'issue_id=?', $req['id'] );
            	$where2 = $handlerTable->getAdapter()->quoteInto( ' AND task_id IS NULL ', "" );
            	$handlerTable->delete( $where. $where2 );

            	// regist handle user.
            	$handlerData = array(
            	       "user_id"  => $eachHandler,
            	       "issue_id" => $req['id']
            	);

            	$handlerTable->insert( $handlerData );
            }
        }

        $this->view->assign( "backmode", $this->getBackMode( $req['backmode'] ) );
    }

    public function finisheditAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Finish issue" );
        $this->view->assign( "nextaction", "finisheditconfirm" );

        $d = db_issues_one( $req['id'] );
        $d["start_date"] = db_common_convdate( $d['start_date'] );
        $d["finished"] = db_common_convdate( $d['finished'], date_explode( ) );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function finisheditconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "finished", "note" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "finishedit" );
            return;
        }

        $this->view->assign( "nextaction", "finisheditcomplete" );
    }

    /**
     *
     *
     */
    public function finisheditcompleteAction(){

    	$config = new Zend_Config_Ini( "common/validation/issues.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "finished", "note" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "finishedit" );
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"issues", "db"=>$db ) );

        $data = array(
            'finished'          => db_common_convdate( $req['finished'] ),
            'note'              => $req['note'],
            'status'            => "1400"
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );
            db_tasks_finish_all( $req['id'] );
        }

        $this->view->assign( "backmode", $this->getBackMode( $req['backmode'] ) );
    }

    public function approveeditAction(){

    	$this->view->assign( "includescript", array( "issue.approve.js" ) );

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Approve issue" );
        $this->view->assign( "nextaction", "approveeditcomplete" );

        $d = db_issues_one( $req['id'] );
        $d["start_date"] = db_common_convdate( $d['start_date'] );
        $d["finished"] = db_common_convdate( $d['finished'], date_explode( ) );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    /**
     *
     *
     */
    public function approveeditcompleteAction(){

    	$req = $this->getRequest()->getParams();

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"issues", "db"=>$db ) );

        $data = array(
            'status'            => $req['approve'] ? "1500" : "1100",
            'approval_user'     => $req['approve'] ? usess_get_userid(true) : null
        );

        if( $req['id'] != "" )
        {
            $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
            $table->update( $data, $where );

        }

        $this->view->assign( "backmode", $this->getBackMode( $req['backmode'] ) );
    }
}