<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "IndexController.php" );

class Issue_IssuesController extends Issue_IndexController
{

    public function indexAction(){
        // action body
        $this->_forward( "top" );
    }

    public function topAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Issue Top" );

        $status_priority = db_summary_issues_priority( usess_selected_project() );
        $status_total = db_summary_issues_status_total( usess_selected_project() );

        $this->view->assign( "status_priority", $status_priority );
        $this->view->assign( "status_total", $status_total );

        $status_severity = db_summary_issues_severity( usess_selected_project() );

        $this->view->assign( "status_severity", $status_severity );

    }

    public function searchAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Search Issue" );

        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_issues_search( usess_selected_project(), $req );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( 50000 );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "list", $arItem->getArrayCopy() );

        $this->view->assignRequest( $req );

    }

    public function newarriveAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "New Arrival" );
        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_issues_list_newarrive( usess_selected_project(), 1100 );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( conf_issueperpage() );
        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "list", $arItem->getArrayCopy() );

        $this->view->assignRequest( $req );
    }

    public function progressAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "In Progress" );
        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_issues_list_newarrive( usess_selected_project(), 1300 );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( conf_issueperpage() );

        $paginator->setView( $this->view );
        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "list", $arItem->getArrayCopy() );

        $this->view->assignRequest( $req );
    }

    public function finishedAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Finished Issues" );
        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_issues_list_newarrive( usess_selected_project(), 1400 );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( conf_issueperpage() );

        $paginator->setView( $this->view );
        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "list", $arItem->getArrayCopy() );

        $this->view->assignRequest( $req );
    }

    public function approvedAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Approved Issues" );
        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_issues_list_newarrive( usess_selected_project(), 1500 );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( conf_issueperpage() );

        $paginator->setView( $this->view );
        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "list", $arItem->getArrayCopy() );

        $this->view->assignRequest( $req );
    }

    public function myissueAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "My Issue" );
        $this->view->assign( "includescript", array( "issue.list.js" ) );

        $paginator = db_issues_list_mine( usess_selected_project(), 1300 );
        $paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( conf_issueperpage() );

        $paginator->setView( $this->view );
        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "list", $arItem->getArrayCopy() );

        $this->view->assignRequest( $req );
    }



}