<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "common/mst/common.php" );

require_once( "common/db/categories.php" );
require_once( "common/db/issues.php" );
require_once( "common/db/summary.php" );
require_once( "common/db/task.php" );

class Issue_IndexController extends Ext_Controller_Action
{

    public function init(){

        if( $this->isNotLogin() ) return;
        if( $this->isNotSelectProject() ) return;

        $subMenu = array();
        $subMenu["100"]["href"] = MVC_HOME. "issue/issues/top";
        $subMenu["100"]["name"] = t( "TOP" );
        $subMenu["150"]["href"] = MVC_HOME. "issue/issues/search";
        $subMenu["150"]["name"] = t( "Search" );
        $subMenu["200"]["href"] = MVC_HOME. "issue/issues/newarrive";
        $subMenu["200"]["name"] = t("New Arrival");
        $subMenu["300"]["href"] = MVC_HOME. "issue/issues/progress";
        $subMenu["300"]["name"] = t("In Progress");
        $subMenu["400"]["href"] = MVC_HOME. "issue/issues/myissue";
        $subMenu["400"]["name"] = t("My Issue");
        $subMenu["500"]["href"] = MVC_HOME. "issue/issues/finished";
        $subMenu["500"]["name"] = t("Finished");
        $subMenu["600"]["href"] = MVC_HOME. "issue/issues/approved";
        $subMenu["600"]["name"] = t("Approved");

        $this->view->assign( "sub_menu", $subMenu );

        $mst = array();

        $mst['phenomenon_types'] = mst_phenomenon_types();
        $mst['priority'] = mst_priority();
        $mst['severity'] = mst_severity();
        $mst['scale']    = mst_scale();
        $mst['users']    = mst_users();
        $mst['categories']= mst_categories();

        $this->view->assign( "m", $mst );

    }

    public function indexAction(){
        // action body
        $this->_redirect( "issue/issues/index" );
    }


}