<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "Zend/Auth.php" );
require_once( "Zend/Auth/Adapter/DbTable.php" );
require_once( "Zend/Auth/Storage/Session.php" );

require_once( "library/Ext/Db/Adapter/Mysql.php" );
require_once( "library/Ext/Db/Statement/Mysql.php" );

require_once( "IndexController.php" );

class Auth_LoginController extends Auth_IndexController
{

    public function init(){
    }

    public function indexAction(){
        // action body
        $this->_forward( "login" );
    }

    public function loginAction(){
        // action body

    	try{
	    	$config = new Zend_Config_Ini( "common/validation/user.ini" , "regist" );
	        $form   = new Ext_Form( $config->user->regist );

	        $req = $this->getRequest()->getParams();
	        $this->view->assignRequest( $req );
	        $this->view->assign( "nologin", true );

	        if( $req['username'] == "" && $req['password'] == "" ) return;

	        $p = array( "username", "password"  );

	        $form->validateAll( $this, $p, $req );


	        if( $form->errorExist() )
	        {
	        	throw new Exception();
	        }

	        $db = DBLOADER::getApp();
	        $authAdapter = new Zend_Auth_Adapter_DbTable(
	            $db,
	            'members',
	            'username',
	            'password'
	        );

	        $authAdapter->setIdentity( $req['username'] );
	        $authAdapter->setCredential( md5( $req['password'] ) );

	        $select = $authAdapter->getDbSelect();
	        $select->where('enabled=1');

	        $auth = Zend_Auth::getInstance();

	        $result = $auth->authenticate($authAdapter);

	        if (!$result->isValid()) {
	        	// 認証に失敗したので、原因を表示します
	        	throw new Exception();
	        	$auth->clearIdentity();
	        } else {
	        	// 認証に成功しました。ID ($username) がセッションに保存されます
	        	// $result->getIdentity() === $auth->getIdentity()
	        	// $result->getIdentity() === $username

	        	$storage = $auth->getStorage();

	        	$storage->write( $authAdapter->getResultRowObject( array(
                  'id', 'username', 'realname', 'email', 'authority', 'last_login'
                ) ) );

                $paginator = db_project_list();
                $paginator->setItemCountPerPage( 1 );
                $tmp = $paginator->getCurrentItems();
                usess_selected_project( $tmp[0]["id"] );
	        }

	        $this->_redirect( "issue" );
	        return;

    	} catch ( Exception $e ) {

    		$this->view->assignLang( "error_message", "authentication failure" );
    	}

    }

    public function logoutAction(){

    	$auth = Zend_Auth::getInstance();
    	$auth->clearIdentity();

    	Zend_Session::destroy();

    	$this->_redirect( "/" );
    }
}