/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.template.HTMLDocument;
import feat2.template.HTMLNode;
import feat2.template.NodeNotFoundException;
import feat2.template.impl.HTMLCompositeNodeImpl;
import feat2.template.impl.TemplateUtil;
import org.w3c.dom.Node;

public abstract class HTMLNodeImpl
implements HTMLNode {
    public HTMLNodeImpl parent;
    public HTMLNodeImpl prev;
    public HTMLNodeImpl next;
    private Node domNode;

    public abstract void setFirstChild(HTMLNode var1);

    public void setNext(HTMLNode next) {
        this.next = (HTMLNodeImpl)next;
    }

    public void setParent(HTMLNode parent) {
        this.parent = (HTMLNodeImpl)parent;
    }

    public void setPrev(HTMLNode prev) {
        this.prev = (HTMLNodeImpl)prev;
    }

    public void setDomNode(Node n) {
        this.domNode = n;
    }

    public Node getDomNode() {
        return this.domNode;
    }

    public HTMLNode getParent() throws NodeNotFoundException {
        if (this.parent == null) {
            throw new NodeNotFoundException();
        }
        return this.parent;
    }

    public HTMLDocument getDocument() throws NodeNotFoundException {
        HTMLNode node = this;
        while (node.getNodeType() != 9) {
            node = node.getParent();
        }
        return (HTMLDocument)node;
    }

    public abstract HTMLNode getFirstChild() throws NodeNotFoundException;

    public HTMLNode getNext() throws NodeNotFoundException {
        if (this.next == null) {
            throw new NodeNotFoundException();
        }
        return this.next;
    }

    public HTMLNode getPrev() throws NodeNotFoundException {
        if (this.prev == null) {
            throw new NodeNotFoundException();
        }
        return this.prev;
    }

    public HTMLNode getFirst() {
        HTMLNode current = this;
        try {
            while (true) {
                current = current.getPrev();
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            return current;
        }
    }

    public HTMLNode getLast() {
        HTMLNodeImpl current = this;
        while (current.next != null) {
            current = current.next;
        }
        return current;
    }

    public void insertAfter(HTMLNode node) {
        if (node == null) {
            return;
        }
        try {
            node.getParent();
            return;
        }
        catch (NodeNotFoundException ex) {
            HTMLNodeImpl lastNode = (HTMLNodeImpl)node.getLast();
            lastNode.setNext(this.next);
            if (this.next != null) {
                this.next.setPrev(lastNode);
            }
            this.next = (HTMLNodeImpl)node;
            ((HTMLNodeImpl)node).setPrev(this);
            TemplateUtil.setParentAll((HTMLNodeImpl)node, lastNode, this.parent);
            return;
        }
    }

    public void insertBefore(HTMLNode node) {
        if (node == null) {
            return;
        }
        try {
            node.getParent();
            return;
        }
        catch (NodeNotFoundException ex) {
            if (this.prev != null) {
                this.prev.setNext(node);
            }
            ((HTMLNodeImpl)node).setPrev(this.prev);
            HTMLNodeImpl lastNode = (HTMLNodeImpl)node.getLast();
            lastNode.setNext(this);
            this.prev = lastNode;
            try {
                if (this.parent != null && this.parent instanceof HTMLCompositeNodeImpl && this.parent.getFirstChild() == this) {
                    ((HTMLCompositeNodeImpl)this.parent).setFirstChild(node);
                }
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                // empty catch block
            }
            TemplateUtil.setParentAll((HTMLNodeImpl)node, lastNode, this.parent);
            return;
        }
    }

    public void detach() {
        if (this.parent != null) {
            HTMLNodeImpl parentNode = this.parent;
            try {
                HTMLNodeImpl childNode = (HTMLNodeImpl)parentNode.getFirstChild();
                if (childNode == this) {
                    parentNode.setFirstChild(this.next);
                }
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                // empty catch block
            }
            this.parent = null;
        }
        if (this.prev != null) {
            this.prev.setNext(this.next);
        }
        if (this.next != null) {
            this.next.setPrev(this.prev);
        }
        this.prev = null;
        this.next = null;
    }
}

