/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.NodeFactory;
import feat2.template.NodeTreeIterator;
import feat2.template.form.ListItem;
import feat2.template.form.Option;
import java.util.ArrayList;

public class OptionGroup
implements ListItem {
    private HTMLElement element;

    public OptionGroup(String label) {
        this.element = NodeFactory.createHTMLElement("optgroup", false);
        this.element.setAttribute("label", label);
    }

    public OptionGroup(HTMLElement element) {
        this.element = element;
    }

    public String getLabel() {
        return this.element.getAttribute("label");
    }

    public void setLabel(String label) {
        this.element.setAttribute("label", label);
    }

    public HTMLElement getElement() {
        return this.element;
    }

    public void addOption(Option option) {
        this.element.addChild(option.getElement());
    }

    public Option[] getOptions() {
        ArrayList<Option> itemList = new ArrayList<Option>();
        NodeTreeIterator it = new NodeTreeIterator(this.element);
        while (it.hasNext()) {
            HTMLElement e;
            HTMLNode node = it.nextNode();
            if (!(node instanceof HTMLElement) || !(e = (HTMLElement)node).getTagName().equalsIgnoreCase("option")) continue;
            itemList.add(new Option(e));
        }
        return itemList.toArray(new Option[itemList.size()]);
    }
}

