/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XMLWriter {
    private SimpleDateFormat dateFormat;
    private StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<response status=\"success\">");
    private boolean close = false;

    public void startObject(String name, String type) {
        this.buf.append("<object name=\"").append(name);
        if (type != null) {
            this.buf.append("\" type=\"").append(type);
        }
        this.buf.append("\">");
    }

    public void endObject() {
        this.buf.append("</object>\r\n");
    }

    public void startList(String name) {
        this.buf.append("<list name=\"").append(name).append("\">");
    }

    public void endList() {
        this.buf.append("</list>\r\n");
    }

    public void endDocument() {
        if (!this.close) {
            this.buf.append("</response>");
            this.close = true;
        }
    }

    public void writeBoolean(String name, boolean value) {
        this.writeProperty(name, value ? "true" : "false", "boolean");
    }

    public void writeNumber(String name, int value) {
        this.writeProperty(name, Integer.toString(value), "number");
    }

    public void writeNumber(String name, short value) {
        this.writeProperty(name, Short.toString(value), "number");
    }

    public void writeNumber(String name, long value) {
        this.writeProperty(name, Long.toString(value), "number");
    }

    public void writeNumber(String name, float value) {
        this.writeProperty(name, Float.toString(value), "number");
    }

    public void writeNumber(String name, double value) {
        this.writeProperty(name, Double.toString(value), "number");
    }

    public void writeNumber(String name, Number value) {
        this.writeProperty(name, value.toString(), "number");
    }

    public void writeString(String name, String value) {
        if (value == null) {
            this.writeProperty(name, null, "string");
        } else {
            this.writeProperty(name, StringUtil.escapeXMLText(value), "string");
        }
    }

    public void writeDate(String name, Date value) {
        if (value == null) {
            this.writeProperty(name, null, "date");
        } else {
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
            }
            this.writeProperty(name, this.dateFormat.format(value), "date");
        }
    }

    private void writeProperty(String name, String value, String type) {
        this.buf.append("<property name=\"").append(name);
        this.buf.append("\" type=\"").append(type);
        if (value == null) {
            this.buf.append("\" isNull=\"true");
        }
        this.buf.append("\">").append(value).append("</property>");
    }

    public void setError(String errorCode) {
        this.buf = new StringBuffer("<?xml version=\"1.0\" ?>\r\n<response status=\"");
        this.buf.append(errorCode).append("\" >");
        this.endDocument();
    }

    public void setError(String errorCode, String message) {
        String encoded = StringUtil.escapeXMLText(message);
        this.buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
        this.buf.append("<response status=\"").append(errorCode).append("\" ");
        this.buf.append("message=\"").append(encoded).append("\">");
        this.endDocument();
    }

    public String toString() {
        this.endDocument();
        return this.buf.toString();
    }
}

