/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.TemplateLoader;
import feat2.TemplateParsingException;
import feat2.View;
import feat2.config.PageConfig;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.HTMLTemplate;
import feat2.template.NodeFactory;
import feat2.template.NodeNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class PageResponse
implements Response {
    private PageConfig pageConfig;

    public PageResponse(PageConfig config) {
        this.pageConfig = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, TemplateParsingException, ApplicationException, FileUploadException {
        HTMLTemplate template = TemplateLoader.load(this.pageConfig.getTemplateFile(), ctx.getLocale(), null);
        String encoding = template.getEncoding();
        HTMLDocument doc = template.getDocument();
        String ret = this.processView(doc, ctx);
        if (ret != null) {
            return ret;
        }
        HttpServletResponse response = ctx.getResponse();
        response.setContentType("text/html;charset=" + encoding);
        if (this.pageConfig.getMaxAge() != null) {
            int maxAge = this.pageConfig.getMaxAge();
            if (maxAge > 0) {
                response.setDateHeader("Expires", System.currentTimeMillis() + (long)(maxAge * 1000));
                response.setHeader("Cache-Control", "max-age=" + maxAge);
            } else {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-cache");
                try {
                    HTMLElement head;
                    HTMLElement html = (HTMLElement)doc.find("html");
                    try {
                        head = html.getTag("head");
                    }
                    catch (NodeNotFoundException ex) {
                        head = NodeFactory.createHTMLElement("head", true);
                    }
                    HTMLElement pragma = NodeFactory.createHTMLElement("meta", false);
                    pragma.setAttribute("http-equiv", "Pragma");
                    pragma.setAttribute("content", "no-cache");
                    HTMLElement cacheControl = NodeFactory.createHTMLElement("meta", false);
                    cacheControl.setAttribute("http-equiv", "Cache-Control");
                    cacheControl.setAttribute("content", "no-cache");
                    head.addChild(pragma);
                    head.addChild(cacheControl);
                }
                catch (NodeNotFoundException ex1) {
                    // empty catch block
                }
            }
        }
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write(doc.toHTML());
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return null;
    }

    private String processView(HTMLDocument doc, CommandContext ctx) throws PropertyAccessException, ApplicationException, FileUploadException {
        ViewConfig[] views = this.pageConfig.getViews();
        for (int i = 0; i < views.length; ++i) {
            Map values = Processor.processInputs(views[i], ctx);
            View view = views[i].getViewInstance();
            if (!Processor.processValidations(view, values, views[i], ctx)) {
                return views[i].getErrorResponse().getValue();
            }
            Processor.processInjection(view, values);
            try {
                view.format(doc, views[i], ctx);
                continue;
            }
            catch (Exception ex) {
                throw new ApplicationException(ex);
            }
        }
        return null;
    }
}

