/*
 * Decompiled with CFR 0.152.
 */
package feat2.config.type;

import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;
import feat2.validation.ValidatorUtil;
import java.util.regex.Pattern;

public class ObjectRef {
    private String name;
    private String nestedPropertyName;
    private static Pattern mappedOptionPattern = Pattern.compile("^\\(.+\\)$");
    private static Pattern indexedOptionPattern = Pattern.compile("^\\[[0-9]+\\]$");

    public ObjectRef() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectRef(String ref) throws IllegalArgumentException {
        int dotIdx = ref.indexOf(46);
        if (dotIdx == -1) {
            if (!Identifier.isIdentifier(ref)) throw new IllegalArgumentException();
            this.name = ref;
            this.nestedPropertyName = null;
            return;
        } else {
            this.name = ref.substring(0, dotIdx);
            this.nestedPropertyName = ref.substring(dotIdx + 1);
            if (!Identifier.isIdentifier(this.name)) {
                throw new IllegalArgumentException();
            }
            if (ObjectRef.isNestedPropertyName(this.nestedPropertyName)) return;
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object obj) {
        return ValidatorUtil.equalOrNull(this.name, ((ObjectRef)obj).name) && ValidatorUtil.equalOrNull(this.nestedPropertyName, ((ObjectRef)obj).nestedPropertyName);
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        if (this.nestedPropertyName != null) {
            hash ^= this.nestedPropertyName.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.nestedPropertyName != null) {
            return this.name + '.' + this.nestedPropertyName;
        }
        return this.name;
    }

    public String getNestedPropertyName() {
        return this.nestedPropertyName;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isNestedPropertyName(String string) {
        if (ValidatorUtil.isBlankOrNull(string)) {
            return false;
        }
        String[] tokens = null;
        if (string.indexOf(46) <= -1) {
            return ObjectRef.isPropertyExpression(string);
        }
        tokens = string.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            if (ObjectRef.isPropertyExpression(tokens[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPropertyExpression(String str) {
        if (ValidatorUtil.isBlankOrNull(str)) {
            return false;
        }
        int mappedIdx = str.indexOf("(");
        int indexedIdx = str.indexOf(91);
        String name = null;
        if (mappedIdx > -1) {
            name = str.substring(0, mappedIdx);
            String opt = str.substring(mappedIdx + 1);
            if (!mappedOptionPattern.matcher(opt).matches()) {
                return false;
            }
        } else if (indexedIdx > -1) {
            name = str.substring(0, indexedIdx);
            String opt = str.substring(indexedIdx + 1);
            if (!indexedOptionPattern.matcher(opt).matches()) {
                return false;
            }
        } else {
            name = str;
        }
        return JavaIdentifier.isJavaIdentifier(name);
    }
}

