/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.FeatRuntimeException;
import feat2.StringUtil;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.DIComponentConfig;
import feat2.config.FeatureConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputSupport;
import feat2.config.ValidatableComponentConfig;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;
import feat2.validation.Validator;

public class ValidationConfig
extends Config
implements DIComponentConfig {
    private Identifier name;
    private String propertyList;
    private String type;
    private JavaIdentifier className;
    private String dependList;
    private String messageId;
    private InputSupport inputs = new InputSupport(this);
    private Class validatorClass;
    private ValidationConfig[] depends;
    private JavaIdentifier[] properties;
    static /* synthetic */ Class class$feat2$validation$ByteValidator;
    static /* synthetic */ Class class$feat2$validation$ShortValidator;
    static /* synthetic */ Class class$feat2$validation$IntValidator;
    static /* synthetic */ Class class$feat2$validation$LongValidator;
    static /* synthetic */ Class class$feat2$validation$FloatValidator;
    static /* synthetic */ Class class$feat2$validation$DoubleValidator;
    static /* synthetic */ Class class$feat2$validation$StringValidator;
    static /* synthetic */ Class class$feat2$validation$RequiredValidator;
    static /* synthetic */ Class class$feat2$validation$NumberRangeValidator;
    static /* synthetic */ Class class$feat2$validation$LengthValidator;
    static /* synthetic */ Class class$feat2$validation$DateValidator;
    static /* synthetic */ Class class$feat2$validation$SimpleDateValidator;
    static /* synthetic */ Class class$feat2$validation$MailAddressValidator;
    static /* synthetic */ Class class$feat2$validation$PostalCodeValidator;
    static /* synthetic */ Class class$feat2$validation$CreditCardValidator;
    static /* synthetic */ Class class$feat2$validation$FileTypeValidator;

    public JavaIdentifier getClassName() {
        return this.className;
    }

    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public ValidationConfig[] getDepends() {
        return this.depends;
    }

    public void setDependList(String dependList) {
        this.dependList = dependList;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public JavaIdentifier[] getProperties() {
        return this.properties;
    }

    public void setProperties(JavaIdentifier[] properties) {
        this.properties = properties;
    }

    public void setPropertyList(String propertyList) {
        this.propertyList = propertyList;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Validator getValidatorInstance() {
        Validator validator = null;
        try {
            validator = (Validator)this.validatorClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new FeatRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new FeatRuntimeException(ex);
        }
        return validator;
    }

    public void addInput(InputConfigBase input) {
        this.inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return this.inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return this.inputs.getInputConfig(propertyName);
    }

    public String getElementName() {
        return "validation";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        FeatureConfig featureConf = this.getFeatureConfig();
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        ret = ret && ConfigUtil.validateRequired(this.propertyList, "properties", this, errs);
        boolean bl = ret = ret && ConfigUtil.validateRequired(this.type, "type", this, errs);
        if (this.propertyList != null) {
            String[] nameList = StringUtil.split(this.propertyList);
            this.properties = new JavaIdentifier[nameList.length];
            for (int i = 0; i < nameList.length; ++i) {
                this.properties[i] = new JavaIdentifier(nameList[i]);
            }
        }
        if (this.getType().equalsIgnoreCase("class")) {
            this.validatorClass = ConfigUtil.validateClass(this.className, "class", this, errs);
            if (this.validatorClass == null) {
                ret = false;
            }
        } else if (this.type.equalsIgnoreCase("byte")) {
            this.validatorClass = class$feat2$validation$ByteValidator == null ? (class$feat2$validation$ByteValidator = ValidationConfig.class$("feat2.validation.ByteValidator")) : class$feat2$validation$ByteValidator;
        } else if (this.type.equalsIgnoreCase("short")) {
            this.validatorClass = class$feat2$validation$ShortValidator == null ? (class$feat2$validation$ShortValidator = ValidationConfig.class$("feat2.validation.ShortValidator")) : class$feat2$validation$ShortValidator;
        } else if (this.type.equalsIgnoreCase("int")) {
            this.validatorClass = class$feat2$validation$IntValidator == null ? (class$feat2$validation$IntValidator = ValidationConfig.class$("feat2.validation.IntValidator")) : class$feat2$validation$IntValidator;
        } else if (this.type.equalsIgnoreCase("long")) {
            this.validatorClass = class$feat2$validation$LongValidator == null ? (class$feat2$validation$LongValidator = ValidationConfig.class$("feat2.validation.LongValidator")) : class$feat2$validation$LongValidator;
        } else if (this.type.equalsIgnoreCase("float")) {
            this.validatorClass = class$feat2$validation$FloatValidator == null ? (class$feat2$validation$FloatValidator = ValidationConfig.class$("feat2.validation.FloatValidator")) : class$feat2$validation$FloatValidator;
        } else if (this.type.equalsIgnoreCase("double")) {
            this.validatorClass = class$feat2$validation$DoubleValidator == null ? (class$feat2$validation$DoubleValidator = ValidationConfig.class$("feat2.validation.DoubleValidator")) : class$feat2$validation$DoubleValidator;
        } else if (this.type.equalsIgnoreCase("string")) {
            this.validatorClass = class$feat2$validation$StringValidator == null ? (class$feat2$validation$StringValidator = ValidationConfig.class$("feat2.validation.StringValidator")) : class$feat2$validation$StringValidator;
        } else if (this.type.equalsIgnoreCase("required")) {
            this.validatorClass = class$feat2$validation$RequiredValidator == null ? (class$feat2$validation$RequiredValidator = ValidationConfig.class$("feat2.validation.RequiredValidator")) : class$feat2$validation$RequiredValidator;
        } else if (this.type.equalsIgnoreCase("range")) {
            this.validatorClass = class$feat2$validation$NumberRangeValidator == null ? (class$feat2$validation$NumberRangeValidator = ValidationConfig.class$("feat2.validation.NumberRangeValidator")) : class$feat2$validation$NumberRangeValidator;
        } else if (this.type.equalsIgnoreCase("length")) {
            this.validatorClass = class$feat2$validation$LengthValidator == null ? (class$feat2$validation$LengthValidator = ValidationConfig.class$("feat2.validation.LengthValidator")) : class$feat2$validation$LengthValidator;
        } else if (this.type.equalsIgnoreCase("date")) {
            this.validatorClass = class$feat2$validation$DateValidator == null ? (class$feat2$validation$DateValidator = ValidationConfig.class$("feat2.validation.DateValidator")) : class$feat2$validation$DateValidator;
        } else if (this.type.equalsIgnoreCase("simple-date")) {
            this.validatorClass = class$feat2$validation$SimpleDateValidator == null ? (class$feat2$validation$SimpleDateValidator = ValidationConfig.class$("feat2.validation.SimpleDateValidator")) : class$feat2$validation$SimpleDateValidator;
        } else if (this.type.equalsIgnoreCase("mail-address")) {
            this.validatorClass = class$feat2$validation$MailAddressValidator == null ? (class$feat2$validation$MailAddressValidator = ValidationConfig.class$("feat2.validation.MailAddressValidator")) : class$feat2$validation$MailAddressValidator;
        } else if (this.type.equalsIgnoreCase("postal-code")) {
            this.validatorClass = class$feat2$validation$PostalCodeValidator == null ? (class$feat2$validation$PostalCodeValidator = ValidationConfig.class$("feat2.validation.PostalCodeValidator")) : class$feat2$validation$PostalCodeValidator;
        } else if (this.type.equalsIgnoreCase("credit-card")) {
            this.validatorClass = class$feat2$validation$CreditCardValidator == null ? (class$feat2$validation$CreditCardValidator = ValidationConfig.class$("feat2.validation.CreditCardValidator")) : class$feat2$validation$CreditCardValidator;
        } else if (this.type.equalsIgnoreCase("filetype")) {
            this.validatorClass = class$feat2$validation$FileTypeValidator == null ? (class$feat2$validation$FileTypeValidator = ValidationConfig.class$("feat2.validation.FileTypeValidator")) : class$feat2$validation$FileTypeValidator;
        } else {
            errs.add(new ConfigError(this.type, "error.config.validation.type", 10, this));
        }
        ValidatableComponentConfig parent = (ValidatableComponentConfig)((Object)this.getParent());
        if (this.dependList != null) {
            String[] elements = StringUtil.split(this.dependList);
            this.depends = new ValidationConfig[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                this.depends[i] = parent.getValidationConfig(elements[i]);
                if (this.depends[i] != null) continue;
                errs.add(new ConfigError(elements[i], "depends", "referrence.validation", 10, this));
            }
        } else {
            this.depends = new ValidationConfig[0];
        }
        ret = ret && this.inputs.validate(errs);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

