/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.ConfigurationException;
import feat2.config.FeatureConfig;
import feat2.config.FileLocator;
import feat2.config.Resources;
import feat2.config.type.Identifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class FeatConfig
extends Config {
    private ArrayList featureList = new ArrayList();
    private HashMap features = null;
    private Resources resources = new Resources();
    private FileLocator configFileLocator;
    private FileLocator appRootLocator;
    private boolean useBodyEncodingForURI = false;
    private int httpPort = -1;
    private int httpsPort = -1;

    public void addFeatureConfig(FeatureConfig feature) {
        this.featureList.add(feature);
        feature.setParent(this);
    }

    public FeatureConfig getFeatureConfig(String featureName) throws IllegalStateException {
        if (this.features == null) {
            throw new IllegalStateException("validate\u30e1\u30bd\u30c3\u30c9\u304c\u547c\u3070\u308c\u308b\u524d\u306bgetFeatureConfig\u30e1\u30bd\u30c3\u30c9\u304c\u547c\u3070\u308c\u307e\u3057\u305f");
        }
        return (FeatureConfig)this.features.get(featureName);
    }

    public void addResources(Resources resources) {
        this.resources.addResources(resources);
    }

    public String getStringResource(String resourceName, Locale locale) {
        return this.resources.getString(resourceName, locale);
    }

    public Resources getResources() {
        return this.resources;
    }

    public Iterator getFeatures() {
        return this.featureList.iterator();
    }

    public FileLocator getAppRootLocator() {
        return this.appRootLocator;
    }

    public void setAppRootLocator(FileLocator appRootLocator) {
        this.appRootLocator = appRootLocator;
    }

    public FileLocator getConfigFileLocator() {
        return this.configFileLocator;
    }

    public void setConfigFileLocator(FileLocator configFileLocator) {
        this.configFileLocator = configFileLocator;
    }

    public Identifier getName() {
        return null;
    }

    public boolean isUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getElementName() {
        return "feat";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        if (!this.useBodyEncodingForURI) {
            errs.add(new ConfigError(null, "warn.config.feat.useBodyEncodingForURI.false", 11, this));
        }
        this.features = new HashMap();
        Iterator iter = this.featureList.iterator();
        while (iter.hasNext()) {
            FeatureConfig featureConf = (FeatureConfig)iter.next();
            this.features.put(featureConf.getName().getValue(), featureConf);
        }
        boolean bl = ret = ret && ConfigUtil.validate(this.featureList.iterator(), errs);
        if (this.configFileLocator == null) {
            throw new ConfigurationException("exception.config.feat.configFileLocator.null");
        }
        if (this.appRootLocator == null) {
            throw new ConfigurationException("exception.config.feat.appRootLocator.null");
        }
        return ret;
    }
}

