/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.ActionConfigBase;
import feat2.config.Config;
import feat2.config.ConfigUtil;
import feat2.config.ConfigurationException;
import feat2.config.Dependencies;
import feat2.config.ExceptionConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputObjectConfig;
import feat2.config.OutputConfig;
import feat2.config.type.Identifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CommandConfig
extends Config {
    private Identifier name;
    private Boolean createSession;
    private String encoding;
    private String scheme;
    private ArrayList actions = new ArrayList();
    private ArrayList exceptions = new ArrayList();
    private HashMap outputs = new HashMap();
    private boolean sorted = false;

    public Boolean getCreateSession() {
        return this.createSession;
    }

    public void setCreateSession(Boolean createSession) {
        this.createSession = createSession;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void addAction(ActionConfigBase action) {
        this.actions.add(action);
        action.setParent(this);
        this.sorted = false;
    }

    public ActionConfigBase getActionComponentConfig(String name) {
        for (int i = 0; i < this.actions.size(); ++i) {
            ActionConfigBase conf = (ActionConfigBase)this.actions.get(i);
            if (!conf.getName().getValue().equals(name)) continue;
            return conf;
        }
        return null;
    }

    public ActionConfigBase[] getActions() throws ConfigurationException {
        if (!this.sorted) {
            this.actions = this.getExecutionList(this.actions);
            this.sorted = true;
        }
        return this.actions.toArray(new ActionConfigBase[0]);
    }

    public void addException(ExceptionConfig exception) {
        this.exceptions.add(exception);
        exception.setParent(this);
    }

    public ExceptionConfig getException(Class exclass) {
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            ExceptionConfig exc = (ExceptionConfig)it.next();
            if (!exc.getCatchClass().isAssignableFrom(exclass)) continue;
            return exc;
        }
        return null;
    }

    public void addOutput(OutputConfig output) {
        this.outputs.put(output.getName().getValue(), output);
        output.setParent(this);
    }

    public OutputConfig getOutputConfig(String name) {
        return (OutputConfig)this.outputs.get(name);
    }

    public String getElementName() {
        return "command";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        ret = ret && ConfigUtil.validate(this.actions.iterator(), errs);
        ret = ret && ConfigUtil.validate(this.exceptions.iterator(), errs);
        ret = ret && ConfigUtil.validate(this.outputs.values().iterator(), errs);
        return ret;
    }

    private ArrayList getExecutionList(List components) throws ConfigurationException {
        ArrayList<Object> ret = new ArrayList<Object>();
        Dependencies dep = new Dependencies();
        for (int i = 0; i < components.size(); ++i) {
            ActionConfigBase config = (ActionConfigBase)components.get(i);
            dep.addDependency(config, null);
            InputConfigBase[] inputs = config.getInputs();
            for (int ii = 0; ii < inputs.length; ++ii) {
                if (!(inputs[ii] instanceof InputObjectConfig)) continue;
                String targetName = ((InputObjectConfig)inputs[ii]).getRef().getName();
                ActionConfigBase target = this.getActionComponentConfig(targetName);
                dep.addDependency(config, target);
            }
        }
        while (dep.count() > 0) {
            Object o = dep.getIndependentObject();
            if (o == null) {
                throw new ConfigurationException("error.config.CommandConfig.recurrence");
            }
            dep.removeDependencies(o);
            ret.add(o);
        }
        return ret;
    }
}

