/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.config.FileLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BasicFileLocator
implements FileLocator {
    private File file;
    private FileLocator rootLocation;

    public BasicFileLocator(File file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("file:null");
        }
        this.file = file;
        this.rootLocation = this;
    }

    protected BasicFileLocator(File file, FileLocator rootLocation) {
        this(file);
        this.rootLocation = rootLocation == null ? this : rootLocation;
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String getURIString() {
        return this.file.toURI().toASCIIString();
    }

    public FileLocator newLocation(String relativePath) throws IllegalArgumentException {
        if (relativePath == null) {
            return this;
        }
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("\"" + relativePath + "\" '/'\u3067\u59cb\u307e\u308b\u30d1\u30b9\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044");
        }
        if (relativePath.startsWith(".")) {
            throw new IllegalArgumentException("\"" + relativePath + "\" \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306e\u5148\u982d\u306b'.'\u306f\u4f7f\u7528\u3067\u304d\u306a\u3044");
        }
        if (relativePath.indexOf("..") > -1) {
            throw new IllegalArgumentException("\"" + relativePath + "\" \u4e0a\u4f4d\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044");
        }
        if (this.file.isFile()) {
            return new BasicFileLocator(new File(this.file.getParentFile(), relativePath), this.rootLocation);
        }
        return new BasicFileLocator(new File(this.file, relativePath), this.rootLocation);
    }

    public FileLocator rootLocation() {
        return this.rootLocation;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getFilename() {
        if (this.file.isFile()) {
            return this.file.getName();
        }
        return null;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public boolean equals(Object o) {
        BasicFileLocator loc = (BasicFileLocator)o;
        boolean ret = this.file.equals(loc.file);
        if (this.rootLocation != this) {
            ret = ret && this.rootLocation.equals(loc.rootLocation);
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.rootLocation != this) {
            buf.append("<").append(this.rootLocation.toString()).append(">");
        }
        buf.append(this.file.getPath());
        return buf.toString();
    }
}

