/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.FeatError;
import feat2.FileResourceManager;
import feat2.ResourceManager;
import feat2.StringUtil;
import feat2.config.Config;
import feat2.config.ValidationConfig;
import java.util.HashMap;

public class ValidationError
implements FeatError {
    private String featureName;
    private ValidationConfig config;
    private String messageId;
    private ResourceManager rm;
    private HashMap keywords;

    public ValidationError(String messageId, ValidationConfig validationConfig) {
        this.messageId = messageId;
        this.featureName = validationConfig.getFeatureConfig().getName().getValue();
        this.config = validationConfig;
        this.keywords = new HashMap();
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getValidationName() {
        return this.config.getName().getValue();
    }

    public Config getComponentConfig() {
        return this.config;
    }

    public int getErrorLevel() {
        return 10;
    }

    public void setResourceManager(ResourceManager rm) {
        this.rm = rm;
    }

    public void addKeyrowd(String key, String value) {
        this.keywords.put(key, value);
    }

    public String getMessage() throws IllegalStateException {
        String ret = this.getResource(this.messageId);
        if (ret != null) {
            ret = StringUtil.replaceParameters(ret, this.keywords);
        }
        return ret;
    }

    private String getResource(String name) {
        if (name == null) {
            return null;
        }
        String ret = null;
        if (this.rm != null) {
            ret = this.rm.getStringResource(name);
        }
        if (ret == null) {
            ret = FileResourceManager.getInstance().getStringResource(name);
        }
        if (ret == null) {
            ret = name;
        }
        return ret;
    }
}

