/*
 * $Id: HTMLTemplateParser.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/10/23
 */
package feat2.template;

import java.io.IOException;

import feat2.TemplateParsingException;
import feat2.config.FileLocator;

/**
 * HTMLパーサのインターフェイス。
 * @author SUGIMOTO Ken-ichi
 */
public interface HTMLTemplateParser {

    /**
     * HTMLを読み込む。
     * @param loc 読み込むファイル
     * @param encoding HTMLのエンコーディング。nullを指定するとHTMLから判断する
     * @return
     * @throws TemplateParsingException パース中に例外がスローされたとき
     * @throws IOException HTMLデータ読み込み中のIO例外
     */
    public HTMLTemplate parseTemplate(FileLocator loc, String encoding) throws TemplateParsingException, IOException;

}
