/*
 * $Id: ViewConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.View;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * ビューコンポーネントの設定。
 * @author SUGIMOTO Ken-ichi
 */
public class ViewConfig extends Config implements DIComponentConfig, ValidatableComponentConfig {

    // インスタンス変数 -------------------------------------------------------

    //private Identifier name;
    private JavaIdentifier className;
    private InputSupport inputs;
    private ValidationSupport validations;
    private Identifier errorResponse;

    // validationメソッドで有効になる変数 -------------------------------------

    private Class viewClass;


    // コンストラクタ ---------------------------------------------------------

    public ViewConfig() {
        inputs = new InputSupport(this);
        validations = new ValidationSupport(this);
    }


    // プロパティ -------------------------------------------------------------

    /*public Identifier getName() {
        return name;
    }
    public void setName(Identifier name) {
        this.name = name;
    }*/

    public Identifier getName() {
        return null;
    }

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public Identifier getErrorResponse() {
        return errorResponse;
    }
    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }


    // インスタンスメソッド ---------------------------------------------------

    public View getViewInstance() {
        try {
            return (View)viewClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }
    }


    // DIComponentConfigのメソッド --------------------------------------------

    public void addInput(InputConfigBase input) {
        inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return inputs.getInputConfig(propertyName);
    }


    // ValidatableComponentConfigのメソッド -----------------------------------

    public void addValidation(ValidationConfig validation) {
        validations.addValidation(validation);
    }
    public ValidationConfig[] getValidations() {
        return validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return getInputConfig(propertyName).getDisplayName();
    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "view";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        // className

        viewClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( viewClass == null )
            ret = false;

        if ( validations.count() > 0 && errorResponse == null ) {
            errs.add( new ConfigError(null, "error-response", ConfigError.TYPE_ERROR_RESPONSE, FeatError.ERROR, this) );
        }

        ret = ret && inputs.validate(errs);
        ret = ret && validations.validate(errs);

        return ret;
    }

}
