/*
 * $Id: InputObjectConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.type.ObjectRef;
import feat2.config.type.Scope;

/**
 * オブジェクト入力の設定。
 * @author SUGIMOTO Ken-ichi
 */
public class InputObjectConfig extends InputConfigBase {

    private ObjectRef ref;
    private Scope scope;

    // プロパティ -------------------------------------------------------------

    public ObjectRef getRef() {
        return ref;
    }
    public void setRef(ObjectRef ref) {
        this.ref = ref;
    }

    public Scope getScope() {
        return scope;
    }
    public void setScope(Scope scope) {
        this.scope = scope;
    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "input";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( ref == null && getPropertyName() != null )
            ref = new ObjectRef(getPropertyName().getValue());

        return ret;
    }

}
