/*
 * $Id: FeatException.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

package feat2;

import java.util.HashMap;

public class FeatException extends Exception {

    private static final long serialVersionUID = "$Id: FeatException.java 220 2007-07-16 10:32:15Z sugimotokenichi $".hashCode();

    private String messageId;
    private HashMap keywords;


    public FeatException() {
        super();
        keywords = new HashMap();
    }

    public FeatException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatException(String messageId) {
        super();
        this.messageId = messageId;
        keywords = new HashMap();
    }

    public FeatException(Throwable cause) {
        super(cause);
        keywords = new HashMap();
    }


    public String getMessageId() {
        return messageId;
    }


    /**
     * メッセージ中のキーワード置き換えを追加する。
     * @param key
     * @param word
     */
    public void addKeyword(String key, String word) {
        keywords.put(key, word);
    }


    /**
     * メッセージIDに対応するエラーメッセージを返す。
     * リソースマネージャはデフォルトのFileResourceManagerが使われる。
     * リソースが見つからないときはリソースIDを返す。
     */
    public String getMessage() {

        String message = null;
        if ( messageId != null )
            message = FileResourceManager.getInstance().getStringResource(messageId);

        if ( message == null )
            return messageId;

        message = StringUtil.replaceParameters(message, keywords);
        return message;

    }


}
