﻿/*
 * $Revision: 223 $ $Date: 2007-10-14 17:07:40 +0900 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

import feat2.*;

// コマンドの非同期実行の戻り値。
// コマンドの実行を管理する。
class feat2.Future {

    private static var serial:Number = 0;

    private var cmd:Command;
    private var observer:CommandObserver;
    private var doneFlag:Boolean;
    private var errorCode:String;
    private var errorMessage:String;
    private var res:XMLNode;
    private var serialId:Number;

    function Future(command:Command, observer_:CommandObserver) {
        cmd = command;
        observer = observer_;
        doneFlag = false;
        errorCode = null;
        errorMessage = "";
        res = null;
        serialId = serial++;
    }

    // コマンドを終了を通知する。
    // resxml - サーバから受け取ったコマンドの結果。
    function done(res:XMLNode):Void {
        this.res = res;
        if ( !doneFlag ) {
            doneFlag = true;
            if ( res == null ) {
                setErrorCode("null_response");
            }
            else {
                if ( res.attributes.status == "success" ) {
                    notice();
                }
                else {
                    error(res.attributes.status, unescape(res.attributes.message));
                }
            }
        }
    }

    // エラーが起きたときに呼び出される。
    // observerにエラーを通知する。
    function error(errorCode:String, errorMessage:String):Void {
        //_root.debug("[Future#error] コマンド終了 errorCode:"+errorCode);
        setErrorCode(errorCode);
        if ( errorMessage != null )
            setErrorMessage(errorMessage);
        if ( observer != null ) {
            observer.error(this);
        }
    }

    private function notice():Void {
        //_root.debug("[Future#notice] コマンド正常終了");
        if ( observer != null ) {
            observer.done(this);
        }
    }

    // エラーコードを設定する。
    // コマンドの実行を終了して、observerにエラーを通知する。
    private function setErrorCode(errorCode:String):Void {
        this.errorCode = errorCode;
        doneFlag = true;
    }

    function getErrorCode():String {
        return errorCode;
    }

    private function setErrorMessage(message:String):Void {
        if ( message == null )
            errorMessage = "";
        else
            errorMessage = message;
    }
    function getErrorMessage():String {
        return errorMessage;
    }

    function isDone():Boolean {
        return doneFlag;
    }

    function isError():Boolean {
        return isDone() && errorCode != null;
    }

    function getCommand():Command {
        return cmd;
    }

    function getObserver():CommandObserver {
        return observer;
    }

    function getResponse(factory:ObjectFactory):Object {
        if ( res == null )
            return null;

        var obj:Object = XMLReader.read(res, factory);
        return obj;
    }

    function getSerialId():Number {
        return serialId;
    }
}
