/*
 * $Id: ExceptionView.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/04/23
 */
package feat2.testapp.test7;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import feat2.CommandContext;
import feat2.View;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;

public class ExceptionView implements View {

    private static final Log log = LogFactory.getLog(ExceptionView.class);

    public HTMLDocument format(HTMLDocument template, ViewConfig cfg,
            CommandContext ctx) throws Exception {

        Throwable ex = ctx.getException();
        log.error("", ex);

        template.findElement("exception").setText(ex.getClass().getName());
        template.findElement("message").setText(ex.getMessage());

        return template;
    }

}
