/*
 * $Id: FileTypeValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/04/18
 */
package feat2.validation;

import java.util.HashMap;
import java.util.Map;

import feat2.CommandContext;
import feat2.StringUtil;

/**
 * アップロードされたファイルタイプの検証。
 * @author SUGIMOTO Ken-ichi
 */
public class FileTypeValidator implements ObjectValidator {

    private String[] acceptTypes;

    public boolean validate(Object value) {

        if ( value == null )
            return true;

        if ( acceptTypes == null || acceptTypes.length == 0 )
            return false;

        if ( value instanceof CommandContext.MultipartFormItem ) {
            CommandContext.MultipartFormItem item = (CommandContext.MultipartFormItem)value;
            String fileName = item.getFileName().toUpperCase();

            for (int i = 0; i < acceptTypes.length; i++) {
                String ext = "."+acceptTypes[i];
                if ( fileName.endsWith(ext) )
                    return true;
            }
        }

        return false;

    }

    public String getDefaultMessageId() {
        if ( acceptTypes.length == 1 )
            return "error.validation.filetype";
        else
            return "error.validation.filetypes";
    }

    public Map getKeyrowds() {
        HashMap ret = new HashMap();
        ret.put("types", StringUtil.join(acceptTypes, ", "));
        return ret;
    }


    /**
     * 受理できるファイルの拡張子リストを設定する。
     * @param types 半角スペース区切りの拡張子リスト。先頭にピリオドは付けない。比較は大文字/小文字を区別せずに行われる。
     */
    public void setAcceptTypes(String types) {
        acceptTypes = StringUtil.split(types.toUpperCase(), " ");
    }

}
