/*
 * $Id: NodeIterator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/10/29
 */
package feat2.template;

import java.util.Iterator;

/**
 * ノードのイテレータの基本インターフェイス。
 * @author SUGIMOTO Ken-ichi
 */
public interface NodeIterator extends Iterator {

    /**
     * 現在位置をマークする。
     */
    public void mark();

    /**
     * マークした位置に戻る。
     */
    public void reset();

    /**
     * 指定のオブジェクトが見つかる位置までイテレータを進める。
     * オブジェクトが見つからなかったらこのメソッドを呼び出す前の状態に戻る。
     * このメソッドではマークの位置は変更されない。
     * @param o
     * @return オブジェクトが見つからなかったらfalse
     */
    public boolean skip(Object o);

    /**
     * 戻り値がHTMLNode型のnextメソッド。
     * @return
     */
    public HTMLNode nextNode();
}
