/*
 * $Id: Scope.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/15
 */
package feat2.config.type;

/**
 * オブジェクトのスコープをあらわすクラス。
 * @author SUGIMOTO Ken-ichi
 */
public class Scope {

    public static final int
        LOCAL = 0,
        REQUEST = 1,
        USER = 2,
        SESSION = 3,
        APPLICATION = 4;

    private int scope;

    public Scope(String scopeName) throws IllegalArgumentException {

        if ( scopeName.equalsIgnoreCase("local") )
            scope = LOCAL;
        else if ( scopeName.equalsIgnoreCase("request") )
            scope = REQUEST;
        else if ( scopeName.equalsIgnoreCase("user") )
            scope = USER;
        else if ( scopeName.equalsIgnoreCase("session") )
            scope = SESSION;
        else if ( scopeName.equalsIgnoreCase("application") )
            scope = APPLICATION;
        else
            throw new IllegalArgumentException("\""+scopeName+"\"は正しいスコープではありません");

    }

    public boolean isLocal() {
        return scope == LOCAL;
    }

    public boolean isRequest() {
        return scope == REQUEST;
    }

    public boolean isUser() {
        return scope == USER;
    }

    public boolean isSession() {
        return scope == SESSION;
    }

    public boolean isApplication() {
        return scope == APPLICATION;
    }

    public int getScope() {
        return scope;
    }



}
