/*
 * $Id: FeatError.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/21
 */
package feat2;

import feat2.config.Config;

/**
 * featフレームワーク内のエラーの一般型。
 * @author SUGIMOTO Ken-ichi
 */
public interface FeatError {

    /*public static final String
        TYPE_VALIDATION = "validation",
        TYPE_COMMAND = "command",
        TYPE_VIEW = "response";*/
    public static final int
        ERROR = 10,
        WARN = 11;

    /**
     * メッセージのリソースIdを返す。
     * @return
     */
    public String getMessageId();

    public void setResourceManager(ResourceManager rm);

    /**
     * エラーメッセージを返す。
     * リソースはFeatErrorsに設定されたリソースマネージャから取得する。
     * FeatErrorsに追加されていない状態ではデフォルトのリソースマネージャからリソースを取得する。
     * @return
     */
    public String getMessage() throws IllegalStateException;

    public String getFeatureName();

    public Config getComponentConfig();

    //public String getType();

    public int getErrorLevel();
}
