﻿/*
 * $Revision: 223 $ $Date: 2007-10-14 17:07:40 +0900 $
 * Copyright (C) 2004-2007 SUGIMOTO Ken-ichi
 */

import feat2.Future;
import feat2.CommandObserver;
import feat2.ResponseXML;
import feat2.ObjectCommand;

/**
 * 通信を制御するムービークリップ。
 */
class feat2.ServiceDelegate extends MovieClip {

    private var queue:Array;
    private var currentFuture;
    private var baseUrl:String
    private var executorUrl:String
    private var executorSuffix:String
    // タイムアウト時間 (フレーム数)
    private var timeoutLimit_:Number;
    private var timeCount:Number;
    private var mode:Number;


    function ServiceDelegate() {
        queue = new Array();
        timeoutLimit_ = 360;
        mode = 0;
        baseUrl = this._url.substring(0, this._url.lastIndexOf("/")) + "/";
        executorUrl = baseUrl + "executor";
        executorSuffix = ".do";

    }


    // コマンドを実行する。
    function executeObject(featureName:String, commandName:String, obj:Object, observer:CommandObserver):Future {

        var cmd = new ObjectCommand(featureName, commandName, obj);

        // コマンドの実行を管理するオブジェクト
        var fu:Future = new Future(cmd, observer);

        // キューに追加
        queue.push(fu);
        _root.debug("[ServiceDelegate#xexcuteObject] コマンドをキューに追加 id:"+fu.getSerialId()+"command:"+featureName+"/"+commandName);

        return fu;

    }


    // フレームの開始。
    // キューをポーリングしてコマンドがあったら実行する。
    function onEnterFrame() {

        switch (mode) {
            case 0:
                // コマンドを送信したらモード1へ
                if ( sendCommand() ) {
                    mode = 1;
                    timeCount = 0;
                    _root.debug("[ServiceDelegate#onEnterFrame] コマンド応答待ちに移行");
                }
                break;

            case 1:
                // コマンド応答待ち
                timeCount++;
                if ( timeCount > timeoutLimit_ ) {
                    // タイムアウト
                    mode = 0;
                    timeout();
                }
                break;
        }

    }


    // コマンドをサーバに送る
    private function sendCommand():Boolean {

        if ( queue.length > 0 ) {
            currentFuture = queue.shift();

            var cmdXml:XML = currentFuture.getCommand().toXML();
            // 結果を受け取るXMLオブジェクトにFutureを持たせる
            var result:ResponseXML = new ResponseXML(this, currentFuture);

            // onLoadハンドラの登録
            var handler:Function = function(success) {
                if ( success ) {
                    this.delegate.done(this);
                }
                else {
                    this.delegate.error(this, "communication_error");
                }
            }
            result.onLoad = handler;

            // 通信開始
            _root.debug("[ServiceDelegate#sendCommand] 通信開始 id:"+currentFuture.getSerialId());
            cmdXml.addRequestHeader("x-xmlcommand", "xmlcommand");
            cmdXml.sendAndLoad(executorUrl + executorSuffix, result);

            return true;
        }
        else
            return false;

    }


    function done(resxml:ResponseXML) {
        var future:Future = resxml.getFuture();
        if ( future.isError() ) {
            _root.debug("[ServiceDelegate#done] タイムアウトしたコマンドのレスポンスを受け取った id:"+future.getSerialId());
            return;
        }

        _root.debug("[ServiceDelegate#done] コマンド正常終了 id:"+future.getSerialId());

        var response:XMLNode = ResponseXML.findElement(resxml, "response");
        future.done(response);
        mode = 0;
    }


    function error(resxml:ResponseXML, errorCode:String) {
        var future:Future = resxml.getFuture();
        if ( future.isError() ) {
            _root.debug("[ServiceDelegate#error] タイムアウトしたコマンドのレスポンスを受け取った id:"+future.getSerialId());
            return;
        }

        _root.debug("[ServiceDelegate#error] コマンドエラー error:"+errorCode+" id:"+future.getSerialId());

        future.error(errorCode, null);
        mode = 0;
    }


    function timeout() {
        _root.debug("[ServiceDelegate#timeout] コマンドタイムアウト id:"+currentFuture.getSerialId());
        currentFuture.error("timeout", null);
    }


    // 現在サーバに送って返事待ちをしているコマンドを返す。
    function getCurrentFuture():Future {
        return currentFuture;
    }

    // 通信するサーブレットのURLを設定する。
    function setExecutorURL(url:String):Void {
        executorUrl = url;
        _root.debug("[ServiceDelegate#setExecutorURL] 通信先URL: "+url);
    }

    function getExecutorURL():String {
        return executorUrl;
    }


    // 通信先サーブレットの接尾辞を設定する。
    // サーブレットマッピングに "*.do"のような指定を行っている場合に必要。
    function setExecutorSuffix(suffix:String):Void {
        executorSuffix = suffix;
    }
    function getExecutorSuffix():String {
        return executorSuffix;
    }


    // タイムアウト時間を設定する。単位はフレーム。
    function setTimeout(numFrames:Number):Void {
        timeoutLimit_ = numFrames;
    }
    function getTimeout():Number {
        return timeoutLimit_;
    }

}
