/*
 * $Id: ConfigReaderTest.java,v 1.1 2006/04/11 16:17:48 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/11
 */
package feat2.test;

import junit.framework.TestCase;
import feat2.FeatError;
import feat2.FeatErrors;
import feat2.FileResourceManager;
import feat2.config.ClassLoaderFileLocator;
import feat2.config.ConfigReader;
import feat2.config.FeatConfig;

public class ConfigReaderTest extends TestCase {

    public void testLoadConfig() throws Exception {
        ClassLoader loader = ConfigReaderTest.class.getClassLoader();

        ClassLoaderFileLocator locator = new ClassLoaderFileLocator("feat2/test/feat-config-test.xml", loader);

        FileResourceManager rm = new FileResourceManager();
        rm.addResourceFile("resources.xml", loader);
        FeatErrors errs = new FeatErrors(rm);

        FeatConfig fe = ConfigReader.parseFeatConfig(locator, locator);

        assertNotNull(fe);

        boolean valid = fe.validate(errs);
        FeatError[] errors = errs.getErrors(FeatError.ERROR);
        for (int i = 0; i < errors.length; i++) {
            System.out.println(errors[i].getMessage());
        }

        assertTrue(valid);
        assertEquals(errors.length, 0);

        /*ClassLoaderFileLocator locator = new ClassLoaderFileLocator("feat2/testapp/feat-config-test.xml", ConfigReaderTest.class.getClassLoader());
        FeatConfig config = ConfigReader.parseFeatConfig(locator, locator);
        config.validate();

        FeatureDeclaration featureDecl = config.getFeatureDeclaration("test");
        assertNotNull(featureDecl);
        assertEquals(featureDecl.getPackage(), "feat2.testapp");
        assertEquals(featureDecl.getEncoding(), "Windows-31J");
        assertEquals(featureDecl.isCreateSession(), true);

        FeatureConfig featureConfig = featureDecl.getFeatureConfig();
        assertNotNull(featureConfig);

        PreProcessDeclaration ppdecl = featureDecl.getPreProcessDeclaration("require");
        assertEquals(ppdecl.getPreProcessClass().getName(), "feat2.preprocess.RequiredParams");
        assertEquals(ppdecl.isContinue(), false);

        CommandDeclaration commDecl = featureDecl.getCommand("hello");
        assertEquals(commDecl.getCommandClass().getName(), "feat2.testapp.SimpleCommand");
        assertEquals(commDecl.getResponsePointer("goto").getName(), "hello");

        ViewDeclaration viewDecl = featureDecl.getView("message");
        assertEquals(viewDecl.getViewClass().getName(), "feat2.testapp.MessageView");

        PageDeclaration pageDecl = (PageDeclaration)featureDecl.getResponseDeclaration("hello");
        assertEquals(pageDecl.getTemplateName(), "simple.html");
        assertEquals(pageDecl.getViewList()[0].getName(), "message");

        ExceptionDeclaration exDecl = featureDecl.getExceptionDeclaration(new IOException());
        assertEquals(exDecl.getResponsePointer().getName(), "hello");
        assertEquals(exDecl.getLog(), "warn");
        assertEquals(exDecl.getLogMessage(), "exception.IOException");*/


    }

}
