/*
 * $Id: SelectControl.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/17
 */
package feat2.template.form;

import java.util.ArrayList;
import java.util.List;

import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.NodeIterator;
import feat2.template.NodeTreeIterator;

/**
 * tH[̃XgRg[B
 * @author SUGIMOTO Ken-ichi
 */
public class SelectControl implements FormControl {

    private HTMLElement element;

    SelectControl(HTMLElement element) {
        this.element = element;
    }

    public ListItem[] getItems() {
        List itemList = new ArrayList();
        for(NodeIterator it = new NodeTreeIterator(element); it.hasNext(); ) {
            HTMLNode node = it.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement e = (HTMLElement)node;
                if ( e.getTagName().equalsIgnoreCase("option") ) {
                    itemList.add(new Option(e));
                }
                else if ( e.getTagName().equalsIgnoreCase("optgroup") ) {
                    itemList.add(new OptionGroup(e));
                }
            }
        }
        return (ListItem[])itemList.toArray(new ListItem[itemList.size()]);
    }

    public Option[] getOptions() {
        List itemList = new ArrayList();
        for(NodeIterator it = new NodeTreeIterator(element); it.hasNext(); ) {
            HTMLNode node = it.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement e = (HTMLElement)node;
                if ( e.getTagName().equalsIgnoreCase("option") ) {
                    itemList.add(new Option(e));
                }
            }
        }
        return (Option[])itemList.toArray(new Option[itemList.size()]);
    }

    public void setItems(ListItem[] items) {
        element.clear();
        for(int i=0; i<items.length; i++) {
            element.addChild(items[i].getElement());
        }
    }

    public void addItem(ListItem item) {
        element.addChild(item.getElement());
    }

    public void clearItems() {
        element.clear();
    }

    /**
     * IꂽXgڂԂB
     * @return Option̔zBIꂽڂȂꍇ͋̔zԂB
     */
    public Option[] getSelectedElements() {
        List itemList = new ArrayList();
        Option[] options = getOptions();
        for(int i=0; i<options.length; i++) {
            if ( options[i].isSelected() ) {
                itemList.add(options[i]);
            }
        }
        return (Option[])itemList.toArray(new Option[itemList.size()]);
    }

    public void setValue(String value) {
        Option[] options = getOptions();
        clearSelected(options);
        setValue(value, options);
    }

    private void clearSelected(Option[] options) {
        for(int i=0; i<options.length; i++) {
            options[i].setSelected(false);
        }
    }

    private void setValue(String value, Option[] options) {
        for(int i=0; i<options.length; i++) {
            String v = options[i].getValue();
            if ( v != null && v.equals(value) ) {
                options[i].setSelected(true);
                break;
            }
        }
    }

    public void setValues(String[] values) {
        Option[] options = getOptions();
        clearSelected(options);
        for(int i=0; i<values.length; i++) {
            setValue(values[i], options);
        }
    }

    public String getValue() {
        Option[] options = getOptions();
        for(int i=0; i<options.length; i++) {
            if ( options[i].isSelected() ) {
                return options[i].getValue();
            }
        }
        return null;
    }

    public String[] getValues() {
        List values = new ArrayList();
        Option[] options = getOptions();
        for(int i=0; i<options.length; i++) {
            if ( options[i].isSelected() ) {
                values.add(options[i].getValue());
            }
        }
        return (String[])values.toArray(new String[values.size()]);
    }

    public HTMLElement getElement() {
        return element;
    }

    public int getType() {
        return TYPE_SELECT;
    }

}
