/*
 * $Id: Form.java,v 1.2 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/06
 */
package feat2.template.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import feat2.template.HTMLElement;
import feat2.template.HTMLNodeList;
import feat2.template.NodeSelector;
import feat2.template.NodeTreeIterator;

/**
 * tH[ȒPɈ߂̃NXB
 * tH[OBJECTvf̓T|[gȂB
 * @author SUGIMOTO Ken-ichi
 */
public class Form {

    private HTMLElement formElement;

    public Form(HTMLElement formElement) {
        this.formElement = formElement;
    }

    /**
     * tH[̃Rg[vfԂB
     * @param name
     * @return nameŎw肳ꂽtH[̃Rg[BȂƂ͋̔z
     */
    public FormControl getControlElement(String name) {

        // nameŌ
        HTMLNodeList result = NodeSelector.selectElementsByAttribute(new NodeTreeIterator(formElement), "name", name);

        // tH[Rg[𒊏o
        ArrayList list = new ArrayList();
        for(int i=0; i<result.size(); i++) {
            HTMLElement node = (HTMLElement)result.get(i);
            String tagName = node.getTagName();
            if ( tagName != null && (
                tagName.equalsIgnoreCase("input") ||
                tagName.equalsIgnoreCase("button") ||
                tagName.equalsIgnoreCase("select") ||
                tagName.equalsIgnoreCase("textarea") ) ) {

                list.add(node);
            }
        }

        // vftH[Rg[IuWFNg
        FormControl ret = null;
        if ( list.size() > 0 ) {
            HTMLElement[] elements = (HTMLElement[])list.toArray(new HTMLElement[list.size()]);
            String tagName = elements[0].getTagName();
            if ( tagName != null ) {

                if ( tagName.equalsIgnoreCase("input") ) {

                    String type = elements[0].getAttribute("type");

                    // P̃Gg
                    if ( type.equalsIgnoreCase("text") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_TEXT);
                    }
                    else if ( type.equalsIgnoreCase("password") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_PASSWORD);
                    }
                    else if ( type.equalsIgnoreCase("submit") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_SUBMIT);
                    }
                    else if ( type.equalsIgnoreCase("reset") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_RESET);
                    }
                    else if ( type.equalsIgnoreCase("file") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_FILE);
                    }
                    else if ( type.equalsIgnoreCase("hidden") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_HIDDEN);
                    }
                    else if ( type.equalsIgnoreCase("image") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_IMAGE);
                    }
                    else if ( type.equalsIgnoreCase("button") ) {
                        ret = new SimpleControl(elements[0], FormControl.TYPE_BUTTON);
                    }

                    // WI{^
                    else if ( type.equalsIgnoreCase("radio") ) {
                        ret = new RadioButton(elements);
                    }

                    // `FbN{bNX
                    else if ( type.equalsIgnoreCase("checkbox") ) {
                        ret = new CheckBox(elements);
                    }

                }

                else if ( tagName.equalsIgnoreCase("button") ) {
                    ret = new SimpleControl(elements[0], FormControl.TYPE_BUTTON_ELEMENT);
                }

                else if ( tagName.equalsIgnoreCase("select") ) {
                    ret = new SelectControl(elements[0]);
                }

                else if ( tagName.equalsIgnoreCase("textarea") ) {
                    ret = new TextArea(elements[0]);
                }
            }
        }

        return ret;
    }

    /**
     * tH[̃Rg[l擾B
     * vf擾l̈ȉ̂ƂB<br>
     * eLXgA{^AHIDDENvf: valuel<br>
     * eLXgGA: eLXgvf<br>
     * `FbN{bNX: checked̂vfvaluel<br>
     * WI{^: checked̂vf̑l<br>
     * j[: selected̂optionvfvaluelA܂̓eLXgvf
     * @param name
     * @return Rg[ȂƂnullԂ
     */
    public String getValue(String name) {
        FormControl control = getControlElement(name);
        if ( control != null )
            return control.getValue();
        else
            return null;
    }

    /**
     * tH[̃Rg[l擾B
     * tH[̒l1̂Ƃ͗vf1̔zԂB
     * @param name
     * @return
     */
    public String[] getValues(String name) {
        FormControl control = getControlElement(name);
        if ( control != null )
            return control.getValues();
        else
            return null;
    }

    /**
     * NGXgp[^̒ltH[ɃZbgB
     * @param request
     */
    public void setValues(HttpServletRequest request) {
        Map params = request.getParameterMap();
        setValues(params);
    }

    public void setValues(Map map) {
        for(Iterator it = map.keySet().iterator(); it.hasNext(); ) {
            String key = (String)it.next();
            String[] values = (String[])map.get(key);
            FormControl control = getControlElement(key);
            if ( control != null ) {
                control.setValues(values);
            }
        }
    }

    /**
     * tH[̃Rg[ɒlZbgB
     * @param name
     * @param value
     */
    public void setValue(String name, String value) {
        FormControl control = getControlElement(name);
        if ( control != null )
            control.setValue(value);
    }

    /**
     * tH[̃Rg[ɒlZbgB
     * @param name
     * @param values
     */
    public void setValue(String name, String[] values) {
        FormControl control = getControlElement(name);
        if ( control != null )
            control.setValues(values);
    }

    /**
     * XgRg[̑IԂB
     * @param name XgRg[̖O
     * @return XgRg[̑IBXgRg[Ȃnull
     */
    public ListItem[] getOptions(String name) {
        FormControl c = getControlElement(name);
        if ( c != null && c instanceof SelectControl ) {
            SelectControl select = (SelectControl)c;
            return select.getItems();
        }
        else
            return null;
    }

    /**
     * XgRg[̑Iݒ肷B
     * @param name XgRg[̖O
     * @param options
     */
    public void setOptions(String name, ListItem[] options) {
        FormControl c = getControlElement(name);
        if ( c != null && c instanceof SelectControl ) {
            SelectControl select = (SelectControl)c;
            select.setItems(options);
        }
    }

    /**
     * XgRg[̑IǉB
     * @param name XgRg[̖O
     * @param option
     */
    public void addOption(String name, ListItem option) {
        FormControl c = getControlElement(name);
        if ( c != null && c instanceof SelectControl ) {
            SelectControl select = (SelectControl)c;
            select.addItem(option);
        }
    }

    /**
     * w̃Rg[Ƀxݒ肷B
     * w̖ÕRg[labelvfȂ牽ȂB
     * Avaluex̖Rg[(INPUTvfsubmit, reset, button)̏ꍇlabelvfł͂ȂRg[valueݒ肷B
     * labelvfforŖIɃRg[w肵ĂȂꍇ̓xݒ肵ȂB
     * @param name
     * @param label
     */
    public void setLabel(String name, String label) {
        FormControl control = getControlElement(name);
        if ( control != null ) {

            // valuexɎgRg[
            if ( (control.getType() & (FormControl.TYPE_BUTTON | FormControl.TYPE_RESET | FormControl.TYPE_SUBMIT)) != 0 ) {
                control.setValue(label);
                return;
            }

            // Rg[IDɌѕtꂽxύX
            HTMLElement element = control.getElement();
            if ( element != null ) {
                setLabel(element, label);
            }
        }
    }

    /**
     * OLRg[Ƀxݒ肷B
     * checkboxradiô݁B
     * @param name
     * @param labels
     */
    public void setLabels(String name, String[] labels) {
        FormControl control = getControlElement(name);
        if ( control != null ) {

            HTMLElement[] elements = null;

            // vf
            if ( control instanceof CheckBox ) {
                elements = ((CheckBox)control).getElements();
            }
            else if ( control instanceof RadioButton ) {
                elements = ((RadioButton)control).getElements();
            }

            // xݒ
            if ( elements != null ) {
                int size = elements.length;

                if ( size > labels.length ) {
                    size = labels.length;
                }

                for(int i=0; i<size; i++) {
                    setLabel(elements[i], labels[i]);
                }
            }

        }
    }

    /**
     * w̃tH[Rg[ɑΉlabelvfɒlݒ肷B
     * @param element
     * @param label
     */
    private void setLabel(HTMLElement element, String label) {
        String id = element.getId();
        if ( id != null ) {
            HTMLElement labelElement = NodeSelector.getElementByAttribute(new NodeTreeIterator(formElement), "for", id);
            if ( labelElement != null ) {
                labelElement.setText(label);
                return;
            }
        }
    }
}
