/*
 * $Id: NodeTreeIterator.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/07/28
 */
package feat2.template;

import java.util.NoSuchElementException;

import feat2.template.impl.HTMLCompositeNodeImpl;
import feat2.template.impl.HTMLNodeImpl;


/**
 * HTMLc[̃Ce[^B
 * @author SUGIMOTO
 */
public class NodeTreeIterator implements NodeIterator {

    private HTMLNodeImpl start;
    private HTMLNodeImpl current;
    private HTMLNodeImpl next;
    private HTMLNodeImpl currentBak;
    private HTMLNodeImpl nextBak;

    /**
     * noden܂Ce[^B
     * @param node null̂Ƃ͍ŏhasNext()falseɂȂ
     */
    public NodeTreeIterator(HTMLNode node) {
        start = nextBak = next = (HTMLNodeImpl)node;
    }

    public void remove() {
        if ( current == null ) {
            throw new IllegalStateException();
        }
        else {
            current.detach();
            current = null;
        }
    }

    public boolean hasNext() {
        return next != null;
    }

    public Object next() {
        return nextNode();
    }

    public HTMLNode nextNode() {
        if ( next == null ) {
            throw new NoSuchElementException();
        }
        else {
            current = next;
            next = null;

            if ( current instanceof HTMLCompositeNodeImpl ) {
                next = ((HTMLCompositeNodeImpl)current).firstChild;
            }

            // qm[hȂΎ̌Zm[hֈڂ
            if ( next == null ) {
                // Jnm[h̎qm[hȂƂ͏I
                if ( current == start )
                    return current;
                next = current.next;
            }

            // ̌Zm[hȂ΁Aem[h̎̃m[hֈڂ
            if ( next == null) {
                HTMLNodeImpl cur_ = current;
                while ( next == null ) {
                    cur_ = (HTMLNodeImpl)cur_.parent;

                    // em[hȂAJn_ɖ߂I
                    if ( cur_ == start || cur_ == null )
                        break;

                    next = cur_.next;
                }
            }
        }
        return current;
    }

    public void mark() {
        currentBak = current;
        nextBak = next;
    }

    public void reset() {
        current = currentBak;
        next = nextBak;
    }

    public boolean skip(Object o) {
        HTMLNodeImpl c = current;
        HTMLNodeImpl n = next;
        while(hasNext()) {
            if ( next() == o )
                return true;
        }
        current = c;
        next = n;
        return false;
    }

}
