/*
 * $Id: PageResponse.java,v 1.5 2006/04/18 16:12:53 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/17
 */
package feat2.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.TemplateLoader;
import feat2.TemplateParsingException;
import feat2.View;
import feat2.config.PageConfig;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;
import feat2.template.HTMLTemplate;

public class PageResponse implements Response {

    private PageConfig pageConfig;

    public PageResponse(PageConfig config) {
        this.pageConfig = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, TemplateParsingException, ApplicationException, FileUploadException {

        // ev[g̃[h

        HTMLTemplate template = TemplateLoader.load(pageConfig.getTemplateFile(), ctx.getLocale(), null);
        String encoding = template.getEncoding();
        HTMLDocument doc = template.getDocument();

        // view̎s

        String ret = processView(doc, ctx);
        if ( ret != null )
            return ret;

        // hLg̏o

        HttpServletResponse response = ctx.getResponse();
        response.setContentType("text/html;charset="+encoding);
        Writer writer = response.getWriter();
        writer.write(doc.toHTML());
        writer.flush();
        writer.close();

        return null;

    }

    private String processView(HTMLDocument doc, CommandContext ctx) throws PropertyAccessException, ApplicationException, FileUploadException {

        ViewConfig[] views = pageConfig.getViews();

        for (int i = 0; i < views.length; i++) {

            // ͒l̎擾

            Map values = Processor.processInputs(views[i], null, ctx);

            View view = views[i].getViewInstance();

            // of[V

            if ( !Processor.processValidations(view, values, views[i], ctx) )
                return views[i].getErrorResponse().getValue();

            // r[̃vpeBɃZbg

            Processor.processInjection(view, values);

            // r[̎s

            try {
                view.format(doc, views[i], ctx);
            }
            catch (Exception ex) {
                throw new ApplicationException(ex);
            }

        }

        return null;

    }

}
