/*
 * $Id: Command.java,v 1.6 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/02
 */
package feat2.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import feat2.Action;
import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FileUploadException;
import feat2.Interceptor;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.ValidationError;
import feat2.config.ActionConfigBase;
import feat2.config.BeanConfig;
import feat2.config.CommandConfig;
import feat2.config.InterceptConfig;
import feat2.config.OutputConfig;

/**
 * R}hB
 * @author SUGIMOTO Ken-ichi
 */
public class Command {

    //private static Log log = LogFactory.getLog(Command.class);

    private HashMap localOutputs;
    private CommandConfig config;


    public Command(CommandConfig config) {
        this.config = config;
        localOutputs = new HashMap();
    }


    /**
     * R}h̃[Jo͂ɃIuWFNgǉB
     * @param name
     * @param o
     */
    public void putObject(String name, Object o) {
        localOutputs.put(name, o);
    }


    public Object getObject(String name) {
        return localOutputs.get(name);
    }


    /**
     * R}hsB
     * @param ctx
     * @return X|XBnullԂƂ
     * @throws PropertyAccessException
     * @throws ApplicationException AvP[ṼR|[lgŗOX[ꂽƂ
     * @throws FileUploadException Abv[hꂽt@C̏Ŗ肪NƂ
     */
    public String execute(CommandContext ctx) throws PropertyAccessException, ApplicationException, FileUploadException {

        ActionConfigBase[] actionConfs = config.getActions();
        String ret = null;

        // C^[Zv^

        Interceptor[] interceptors = selectInterceptors();

        // R}hsÕC^[Zv^s

        for (int i = 0; i < interceptors.length; i++) {
            interceptors[i].before(this, ctx);
        }

        // eANV̎s

        for(int i=0; i<actionConfs.length; i++) {

            Action action = actionConfs[i].getActionInstance();

            Object bean = action;
            if ( action instanceof BeanConfig.BeanAction ) {
                bean = ((BeanConfig.BeanAction)action).getBean(ctx);
            }

            // ͒l܂Ƃ߂

            Map sourceValues = Processor.processInputs(actionConfs[i], localOutputs, ctx);

            // ľ

            if ( !Processor.processValidations(bean, sourceValues, actionConfs[i], ctx) )
                return actionConfs[i].getErrorResponse().getValue();

            // ANṼvpeBlZbg

            Processor.processInjection(bean, sourceValues);

            // G[ȂΎs
            if ( ctx.getFeatErrors().getErrors(ValidationError.class).length == 0 ) {

                // ANV̎s

                Object result;
                try {
                    result = action.execute(ctx);
                }
                catch (Exception ex) {
                    throw new ApplicationException(ex);
                }

                localOutputs.put(actionConfs[i].getName().getValue(), result);

            }

        }

        // o

        ret = processOutput(ctx);

        // R}hs̃C^[Zv^s

        for (int i = 0; i < interceptors.length; i++) {
            interceptors[i].after(this, ctx);
        }

        return ret;

    }



    /**
     * ̃R}hŎsC^[Zv^̃CX^XB
     * @return
     */
    private Interceptor[] selectInterceptors() {

        ArrayList interceptors = new ArrayList();

        InterceptConfig[] interceptConfs = config.getFeatureConfig().getInterceptConfigs();
        for (int i = 0; i < interceptConfs.length; i++) {

            String[] patterns = interceptConfs[i].getPatterns();
            for (int j = 0; j < patterns.length; j++) {

                // p^[̂ЂƂ̃R}hɃ}b`
                // C^[Zv^̃CX^X

                if ( config.getName().getValue().matches(patterns[j]) ) {
                    Interceptor interceptor = interceptConfs[i].getInterceptorInstance();
                    interceptors.add(interceptor);
                    break;
                }

            }

        }

        return (Interceptor[])interceptors.toArray(new Interceptor[interceptors.size()]);

    }


    private String processOutput(CommandContext ctx) {

        // output̎w肪ȂƂ"default"Ƃoutputw肵ƂɂȂ

        String name = ctx.getOutputName();
        if ( name == null ) {
            name = "default";
        }

        OutputConfig outputConf = config.getOutputConfig(name);
        if ( outputConf == null ) {
            // TODO G[o
            return null;
        }
        String responseName = outputConf.getResponse().getValue();

        // [Jo͂o͂IuWFNgIB

        OutputConfig.Mapping[] outputMappings = outputConf.getOutputMapping();
        for (int i = 0; i < outputMappings.length; i++) {

            Object local = localOutputs.get(outputMappings[i].getLocalName());

            // o̓IuWFNg߂l̃}bvƃNGXgAgr[gɃZbg

            ctx.getRequest().setAttribute(outputMappings[i].getOutputName(), local);

        }

        return responseName;
    }


    // vpeB -------------------------------------------------------------

    public CommandConfig getConfig() {
        return config;
    }



}
