/*
 * $Id: ViewConfig.java,v 1.3 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.View;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * r[R|[lg̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class ViewConfig extends Config implements DIComponentConfig, ValidatableComponentConfig {

    // CX^Xϐ -------------------------------------------------------

    //private Identifier name;
    private JavaIdentifier className;
    private InputSupport inputs;
    private ValidationSupport validations;
    private Identifier errorResponse;

    // validation\bhŗLɂȂϐ -------------------------------------

    private Class viewClass;


    // RXgN^ ---------------------------------------------------------

    public ViewConfig() {
        inputs = new InputSupport(this);
        validations = new ValidationSupport(this);
    }


    // vpeB -------------------------------------------------------------

    /*public Identifier getName() {
        return name;
    }
    public void setName(Identifier name) {
        this.name = name;
    }*/

    public Identifier getName() {
        return null;
    }

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public Identifier getErrorResponse() {
        return errorResponse;
    }
    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }


    // CX^X\bh ---------------------------------------------------

    public View getViewInstance() {
        try {
            return (View)viewClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }
    }


    // DIComponentConfig̃\bh --------------------------------------------

    public void addInput(InputConfigBase input) {
        inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return inputs.getInputConfig(propertyName);
    }


    // ValidatableComponentConfig̃\bh -----------------------------------

    public void addValidation(ValidationConfig validation) {
        validations.addValidation(validation);
    }
    public ValidationConfig[] getValidations() {
        return validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return getInputConfig(propertyName).getDisplayName();
    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "view";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        // className

        viewClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( viewClass == null )
            ret = false;

        if ( validations.count() > 0 && errorResponse == null ) {
            errs.add( new ConfigError(null, "error-response", ConfigError.TYPE_ERROR_RESPONSE, FeatError.ERROR, this) );
        }

        ret = ret && inputs.validate(errs);
        ret = ret && validations.validate(errs);

        return ret;
    }

}
