/*
 * $Id: Resources.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import feat2.Util;

/**
 * \[XB
 * @author SUGIMOTO Ken-ichi
 */
public class Resources {

    private Map resourceMap;

    public Resources() {
        resourceMap = new HashMap();
    }

    public void addResource(String name, Locale lang, String value) {
        ResourceKey key = new ResourceKey(name, lang);
        resourceMap.put(key, value);
    }

    synchronized public void addResources(Resources resources) {
        resourceMap.putAll(resources.resourceMap);
    }

    /**
     * \[XԂB
     * langɌɃ}b`郊\[XԂB
     * @param name \[X
     * @param lang ꖼ(nullłǂ)
     */
    public String getString(String name, Locale lang) {
        String ret = (String)resourceMap.get(new ResourceKey(name, lang));
        return ret;
    }

    /**
     * w̃\[XȂƂ̃P[Œ`ĂtrueԂB
     * @param name
     * @return
     */
    public boolean exists(String name) {
        Set keys = resourceMap.keySet();
        for (Iterator iter = keys.iterator(); iter.hasNext();) {
            ResourceKey element = (ResourceKey) iter.next();
            if ( element.name.equals(name) )
                return true;
        }

        return false;
    }

    private class ResourceKey {
        String name;
        Locale lang;
        int hash;

        /**
         *
         * @param name
         * @param lang Bnullłǂ
         */
        ResourceKey(String name, Locale lang) {
            this.name = name;
            if ( lang == null )
                this.lang = Util.NULL_LOCALE;
            else
                this.lang = lang;
            this.hash = -1;
        }

        public boolean equals(Object o) {
            ResourceKey k = (ResourceKey)o;
            return name.equals(k.name) && lang.equals(k.lang);
        }

        public int hashCode() {
            if ( hash == -1 )
                hash = name.hashCode() ^ lang.hashCode();
            return hash;
        }
    }
}
