/*
 * $Id: RedirectConfig.java,v 1.2 2006/04/24 02:18:29 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import java.net.URI;
import java.net.URISyntaxException;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.Response;
import feat2.impl.RedirectResponse;

/**
 * _CNg̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class RedirectConfig extends ResponseConfigBase implements DIComponentConfig {

    private String uri;
    private String method;
    private InputSupport inputs;

    public RedirectConfig() {
        method = "get";
        inputs = new InputSupport(this);
    }

    public String getMethod() {
        return method;
    }
    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return uri;
    }
    public void setUri(String uri) {
        this.uri = uri;
    }

    public Response getResponseInstance() {
        return new RedirectResponse(this);
    }


    // DIComponentConfig̃\bh --------------------------------------------

    public void addInput(InputConfigBase input) {
        inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return inputs.getInputConfig(propertyName);
    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "redirect";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        ret = ret && ConfigUtil.validateRequired(uri, "uri", this, errs);

        if ( uri != null ) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException ex) {
                errs.add(new ConfigError(uri, "uri", ConfigError.TYPE_URI_SYNTAX, FeatError.ERROR, this));
            }
        }

        if ( !method.equalsIgnoreCase("get") && !method.equalsIgnoreCase("post") ) {
            ret = false;
            ConfigError err = new ConfigError(method, "method", ConfigError.TYPE_VALUE, FeatError.ERROR, this);
            err.addKeyrowd("range", "\"post\", \"get\"");
            errs.add(err);
        }

        ret = ret && inputs.validate(errs);

        return ret;
    }

}
