/*
 * $Id: OutputConfig.java,v 1.3 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import java.util.ArrayList;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.IdentifierList;

/**
 * o͂̑Jڂ̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class OutputConfig extends Config {

    private Identifier name;
    private Identifier response;
    private ArrayList outputObjects;

    public OutputConfig() {
        outputObjects = new ArrayList();
    }


    // vpeB -------------------------------------------------------------

    public Identifier getResponse() {
        return response;
    }
    public void setResponse(Identifier response) {
        this.response = response;
    }

    public void setOutputObjects(IdentifierList nameList) {

        for(int i=0; i<nameList.size(); i++) {

            String name = nameList.get(i).getValue();
            Mapping mp = new Mapping(name, name);
            outputObjects.add(mp);

        }

    }


    // CX^X\bh ---------------------------------------------------

    public void addOutputMapping(Identifier localName, Identifier outputName) {
        Mapping o = new Mapping(localName.getValue(), outputName.getValue());
        outputObjects.add(o);
    }

    public Mapping[] getOutputMapping() {
        return (Mapping[])outputObjects.toArray(new Mapping[0]);
    }



    // Config̃\bh -------------------------------------------------------

    public Identifier getName() {
        return name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public String getElementName() {
        return "output";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        ret = ret && ConfigUtil.validateRequired(name, "name", this, errs);
        ret = ret && ConfigUtil.validateRequired(response, "response", this, errs);

        String responseName = response.getValue();
        if ( responseName != null && getFeatureConfig().getResponseConfig(responseName) == null )
            errs.add( new ConfigError(responseName, "response", ConfigError.TYPE_REFERRENCE_RESPONSE, FeatError.ERROR, this) );

        CommandConfig commandConf = (CommandConfig)getParent();
        for(int i=0; i<outputObjects.size(); i++) {

            Mapping m = (Mapping)outputObjects.get(i);
            if ( ConfigUtil.validateRequired(m.getLocalName(), "local-name", this, errs)
                    && ConfigUtil.validateRequired(m.getOutputName(), "output-name", this, errs) ) {

                if ( commandConf.getActionComponentConfig(m.getLocalName()) == null ) {

                    errs.add(new ConfigError(m.getLocalName(), "local-name", ConfigError.TYPE_REFERRENCE, FeatError.ERROR, this) );

                }

            }
            else {
                ret = false;
            }

        }

        return ret;
    }



    // NX -------------------------------------------------------------

    public class Mapping {

        String localName;
        String outputName;

        private Mapping(String localName, String outputName) {
            this.localName = localName;
            this.outputName = outputName;
        }

        public String getLocalName() {
            return localName;
        }

        public String getOutputName() {
            return outputName;
        }


    }

}