/*
 * $Id: FetchConfig.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.Action;
import feat2.FeatError;
import feat2.FeatErrors;

/**
 * tFb`R|[lg̐ݒ
 * @author SUGIMOTO Ken-ichi
 */
public class FetchConfig extends ActionConfigBase {

    private long cache;

    public FetchConfig() {
        cache = 0L;
    }


    // vpeB -------------------------------------------------------------

    public long getCache() {
        return cache;
    }
    public void setCache(long cache) {
        this.cache = cache;
    }



    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "fetch";
    }

    public Action getActionInstance() {

        try {

            return (Action) getActionClass().newInstance();

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( cache < 0L ) {
            errs.add(new ConfigError(Long.toString(cache), "error.config.fetch.cache", FeatError.ERROR, this));
            ret = false;
        }

        return ret;
    }

}
