/*
 * $Id: EffectConfig.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.Action;
import feat2.Effector;
import feat2.FeatError;
import feat2.FeatErrors;

/**
 * GtFNgR|[lg̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class EffectConfig extends ActionConfigBase {

    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "effect";
    }


    public Action getActionInstance() {

        try {

            return (Action) getActionClass().newInstance();

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }


    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( !Effector.class.isAssignableFrom(getActionClass()) ) {
            ret = false;
            errs.add( new ConfigError(getClassName().getValue(), "class", ConfigError.TYPE_EFFECTOR_INTERFACE, FeatError.ERROR, this) );
        }

        return ret;
    }


}
