/*
 * $Id: DataConfig.java,v 1.3 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.Response;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * f[^X|X̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class DataConfig extends ResponseConfigBase implements DIComponentConfig, ValidatableComponentConfig {

    private JavaIdentifier className;
    private InputSupport inputs;
    private ValidationSupport validations;
    private Identifier errorResponse;

    private Class responseClass;

    public DataConfig() {
        inputs = new InputSupport(this);
        validations = new ValidationSupport(this);
    }


    // vpeB -------------------------------------------------------------

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public Identifier getErrorResponse() {
        return errorResponse;
    }
    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }


    // DIComponentConfig̃\bh --------------------------------------------

    public void addInput(InputConfigBase input) {
        inputs.addInput(input);
        input.setParent(this);
    }
    public InputConfigBase[] getInputs() {
        return inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return inputs.getInputConfig(propertyName);
    }


    // ValidatableComponentConfig̃\bh -----------------------------------

    public void addValidation(ValidationConfig validation) {
        validations.addValidation(validation);
    }

    public ValidationConfig[] getValidations() {
        return validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return getInputConfig(propertyName).getDisplayName();
    }


    // ResponseConfigBasẽ\bh -------------------------------------------

    public Response getResponseInstance() {
        try {
            return (Response)responseClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }
    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "data";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        responseClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( responseClass == null )
            ret = false;
        if ( !Response.class.isAssignableFrom(responseClass) ) {
            errs.add(new ConfigError(className.getValue(), "class", ConfigError.TYPE_RESPONSE_INTERFACE, FeatError.ERROR, this) );
        }

        if ( validations.count() > 0 && errorResponse == null ) {
            errs.add( new ConfigError(null, "error-response", ConfigError.TYPE_ERROR_RESPONSE, FeatError.ERROR, this) );
        }

        ret = ret && inputs.validate(errs);
        ret = ret && validations.validate(errs);

        return ret;
    }



}
