/*
 * $Id: CommandConfig.java,v 1.3 2006/04/19 05:59:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import feat2.FeatErrors;
import feat2.config.type.Identifier;

/**
 * R}h̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class CommandConfig extends Config {

    private Identifier name;
    private Boolean createSession;
    private String encoding;
    private String scheme;
    private ArrayList actions;
    private ArrayList exceptions;
    private HashMap outputs;

    private boolean sorted;

    public CommandConfig() {
        actions = new ArrayList();
        exceptions = new ArrayList();
        outputs = new HashMap();

        sorted = false;
    }

    // vpeB -------------------------------------------------------------

    public Boolean getCreateSession() {
        return createSession;
    }
    public void setCreateSession(Boolean createSession) {
        this.createSession = createSession;
    }

    public String getEncoding() {
        return encoding;
    }
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Identifier getName() {
        return name;
    }
    public void setName(Identifier name) {
        this.name = name;
    }

    /**
     * @return
     */
    public String getScheme() {
        return scheme;
    }
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }


    // CX^X\bh ---------------------------------------------------

    /*public void addBean(BeanConfig bean) {
        actionComponents.add(bean);
        bean.setParent(this);
    }

    public void addEffect(EffectConfig effect) {
        actionComponents.add(effect);
        effect.setParent(this);
    }

    public void addFetch(FetchConfig fetch) {
        actionComponents.add(fetch);
        fetch.setParent(this);
    }*/

    public void addAction(ActionConfigBase action) {
        actions.add(action);
        action.setParent(this);
        sorted = false;
    }

    public ActionConfigBase getActionComponentConfig(String name) {
        for(int i=0;i<actions.size(); i++) {
            ActionConfigBase conf = (ActionConfigBase)actions.get(i);
            if ( conf.getName().getValue().equals(name) ) {
                return conf;
            }
        }
        return null;
    }


    /**
     * ANV̎sXgԂB
     * @return
     */
    public ActionConfigBase[] getActions() throws ConfigurationException {

        if ( !sorted ) {
            actions = getExecutionList(actions);
            sorted = true;
        }

        return (ActionConfigBase[])actions.toArray(new ActionConfigBase[0]);

    }


    public void addException(ExceptionConfig exception) {
        exceptions.add(exception);
        exception.setParent(this);
    }


    /**
     * w̗ONXLb`łO̐ݒIuWFNgԂB
     * @param exclass
     * @return ȂnullԂ
     */
    public ExceptionConfig getException(Class exclass) {

        for (Iterator it = exceptions.iterator(); it.hasNext();) {
            ExceptionConfig exc = (ExceptionConfig) it.next();
            if ( exc.getCatchClass().isAssignableFrom(exclass) )
                return exc;
        }

        return null;

    }


    /**
     * outputǉB
     * @param output
     */
    public void addOutput(OutputConfig output) {
        outputs.put(output.getName().getValue(), output);
        output.setParent(this);
    }

    public OutputConfig getOutputConfig(String name) {
        return (OutputConfig)outputs.get(name);
    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "command";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;

        ret = ret && ConfigUtil.validateRequired(name, "name", this, errs);

        ret = ret && ConfigUtil.validate(actions.iterator(), errs);
        ret = ret && ConfigUtil.validate(exceptions.iterator(), errs);
        ret = ret && ConfigUtil.validate(outputs.values().iterator(), errs);

        return ret;
    }

    private ArrayList getExecutionList(List components) throws ConfigurationException {
        ArrayList ret = new ArrayList();
        Dependencies dep = new Dependencies();

        // ˑ֌W

        for(int i=0; i<components.size(); i++) {

            ActionConfigBase config = (ActionConfigBase)components.get(i);
            dep.addDependency(config, null);

            // ͂QƂĂIuWFNgˑȂ̂
            // ׂĈˑ֌Wɒǉ

            InputConfigBase[] inputs = config.getInputs();
            for(int ii=0; ii<inputs.length; ii++) {

                if ( inputs[ii] instanceof InputObjectConfig ) {
                    String targetName = ((InputObjectConfig)inputs[ii]).getRef().getName();
                    ActionConfigBase target = getActionComponentConfig(targetName);
                    dep.addDependency(config, target);
                }

            }

        }

        // š

        while( dep.count() > 0 ) {

            Object o = dep.getIndependentObject();
            if ( o == null ) {

                // ׂẴIuWFNgǂɈˑĂ̂ŁAzQ
                throw new ConfigurationException("error.config.CommandConfig.recurrence");

            }

            dep.removeDependencies(o);
            ret.add(o);
        }

        return ret;
    }

}
