/*
 * $Id: FileResourceManager.java,v 1.2 2006/04/19 05:59:33 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/04/04
 */
package feat2;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import feat2.config.BasicFileLocator;
import feat2.config.ClassLoaderFileLocator;
import feat2.config.ConfigReader;
import feat2.config.FileLocator;
import feat2.config.Resources;
import feat2.config.URLFileLocator;

/**
 * \[XǗNXB
 * @author SUGIMOTO Ken-ichi
 */
public class FileResourceManager implements ResourceManager {

    private static FileResourceManager defaultRM = null;
    private static final Object lock = new Object();
    private static Log log = LogFactory.getLog(FileResourceManager.class);

    public static FileResourceManager getInstance() {

        synchronized (lock) {
            if ( defaultRM == null ) {

                try {
                    defaultRM = new FileResourceManager();
                    defaultRM.addResourceFile(new ClassLoaderFileLocator("resources.xml", FileResourceManager.class.getClassLoader()));
                }
                catch (IllegalArgumentException ex) {
                    log.error("", ex);
                }
                catch (URISyntaxException ex) {
                    log.error("", ex);
                }

            }
        }

        return defaultRM;

    }

    private Resources resources;
    private Locale locale;


    /**
     * ftHgP[̃\[X}l[W쐬B
     */
    public FileResourceManager() {
        this(Locale.getDefault());
    }

    /**
     * w̃P[̃\[X}l[W쐬B
     */
    public FileResourceManager(Locale locale) {
        resources = new Resources();
        if ( locale == null )
            this.locale = Util.NULL_LOCALE;
        else
            this.locale = locale;
    }

    /**
     * \[Xt@C̓eǉB
     * d郊\[X͏㏑B
     * @param file
     */
    public void addResourceFile(File file) {
        try {
            addResourceFile(new BasicFileLocator(file));
        }
        catch (IllegalArgumentException ex) {
            log.warn("IllegalArgumentException - "+ex.getMessage());
        }
    }

    /**
     * \[Xt@C̓eǉB
     * d郊\[X͏㏑B
     * @param url
     */
    public void addResourceFile(URL url) {
        try {
            addResourceFile(new URLFileLocator(url));
        }
        catch (IllegalArgumentException ex) {
            log.warn("IllegalArgumentException - "+ex.getMessage());
        }
    }

    /**
     * \[Xt@C̓eǉB
     * d郊\[X͏㏑B
     * @param resourceName
     * @param loader
     */
    public void addResourceFile(String resourceName, ClassLoader loader) {
        try {
            addResourceFile(new ClassLoaderFileLocator(resourceName, loader));
        }
        catch (IllegalArgumentException ex) {
            log.warn("IllegalArgumentException - "+ex.getMessage());
        }
        catch (URISyntaxException ex) {
            log.warn("URISyntaxException - "+ex.getMessage());
        }
    }

    /**
     * \[Xt@C̓eǉB
     * @param file
     */
    public void addResourceFile(FileLocator file) {
        Resources r = load(file);
        resources.addResources(r);
    }

    private Resources load(FileLocator file) {
        List seq = Util.expandLocale(locale);
        seq.add(Util.NULL_LOCALE);

        // ꖼɁAڍׂɃ}b`t@CT
        Resources ret = null;
        for(int i=0; i<seq.size(); i++) {

            Locale loc = (Locale)seq.get(i);

            // \[Xt@Cǂݍ
            try {
                // ʂ̃t@C
                FileLocator fl = file;
                if ( !loc.equals(Util.NULL_LOCALE) ) {
                    String filename = StringUtil.makeLocaleFilename(fl.getFilename(), loc);
                    fl = file.newLocation(filename);
                }

                // ǂݍ
                if ( fl.exists() ) {
                    ret = ConfigReader.parseResource(fl);
                    break;
                }
            }

            // [hɗOX[ꂽʂ̃t@Cǂݍł݂

            catch (FeatException ex) {
                log.warn("FeatException", ex);
            }
        }
        return ret;
    }

    /**
     * 擾\[Xp[^Œu郆[eBeB\bhB
     * p[^1`3͂ꂼꃊ\[X񒆂"${1}", "${2}", "${3}"ƒuB
     * @param name
     * @return
     */
    public String getString(String name, String param1, String param2, String param3) {
        String ret = getStringResource(name);
        if ( ret != null )
            return StringUtil.replaceParameters(ret, new String[] {param1, param2, param3});
        else
            return null;
    }

    public String getStringResource(String name) {
        return resources.getString(name, null);
    }

}
