/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.collection.AbstractTestCollection;
import org.apache.commons.collections.iterators.AbstractTestListIterator;

public abstract class AbstractTestList
extends AbstractTestCollection {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public AbstractTestList(String testName) {
        super(testName);
    }

    public boolean isSetSupported() {
        return true;
    }

    public void verify() {
        super.verify();
        List list1 = this.getList();
        List list2 = this.getConfirmedList();
        Assert.assertEquals((String)"List should equal confirmed", (Object)list1, (Object)list2);
        Assert.assertEquals((String)"Confirmed should equal list", (Object)list2, (Object)list1);
        Assert.assertEquals((String)"Hash codes should be equal", (int)list1.hashCode(), (int)list2.hashCode());
        int i = 0;
        Iterator iterator1 = list1.iterator();
        Iterator iterator2 = list2.iterator();
        Object[] array = list1.toArray();
        while (iterator2.hasNext()) {
            Assert.assertTrue((String)"List iterator should have next", (boolean)iterator1.hasNext());
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            Assert.assertEquals((String)"Iterator elements should be equal", o1, o2);
            o2 = list1.get(i);
            Assert.assertEquals((String)"get should return correct element", o1, o2);
            o2 = array[i];
            Assert.assertEquals((String)"toArray should have correct element", o1, o2);
            ++i;
        }
    }

    public boolean isEqualsCheckable() {
        return true;
    }

    public Collection makeConfirmedCollection() {
        ArrayList list = new ArrayList();
        return list;
    }

    public Collection makeConfirmedFullCollection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    public abstract List makeEmptyList();

    public List makeFullList() {
        List list = this.makeEmptyList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    public final Collection makeCollection() {
        return this.makeEmptyList();
    }

    public final Collection makeFullCollection() {
        return this.makeFullList();
    }

    public List getList() {
        return (List)this.collection;
    }

    public List getConfirmedList() {
        return (List)this.confirmed;
    }

    public void testListAddByIndexBoundsChecking() {
        List list;
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        try {
            list = this.makeEmptyList();
            list.add(Integer.MIN_VALUE, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeEmptyList();
            list.add(-1, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeEmptyList();
            list.add(1, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeEmptyList();
            list.add(Integer.MAX_VALUE, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListAddByIndexBoundsChecking2() {
        List list;
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        try {
            list = this.makeFullList();
            list.add(Integer.MIN_VALUE, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeFullList();
            list.add(-1, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeFullList();
            list.add(list.size() + 1, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [size + 1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list = this.makeFullList();
            list.add(Integer.MAX_VALUE, element);
            Assert.fail((String)"List.add should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListAddByIndex() {
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        int max = this.getFullElements().length;
        int i = 0;
        while (i <= max) {
            this.resetFull();
            ((List)this.collection).add(i, element);
            ((List)this.confirmed).add(i, element);
            this.verify();
            ++i;
        }
    }

    public void testListEquals() {
        this.resetEmpty();
        List list = this.getList();
        Assert.assertEquals((String)"Empty lists should be equal", (boolean)true, (boolean)list.equals(this.confirmed));
        this.verify();
        Assert.assertEquals((String)"Empty list should equal self", (boolean)true, (boolean)list.equals(list));
        this.verify();
        List<Object> list2 = Arrays.asList(this.getFullElements());
        Assert.assertEquals((String)"Empty list shouldn't equal full", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        list2 = Arrays.asList(this.getOtherElements());
        Assert.assertEquals((String)"Empty list shouldn't equal other", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        this.resetFull();
        list = this.getList();
        Assert.assertEquals((String)"Full lists should be equal", (boolean)true, (boolean)list.equals(this.confirmed));
        this.verify();
        Assert.assertEquals((String)"Full list should equal self", (boolean)true, (boolean)list.equals(list));
        this.verify();
        list2 = this.makeEmptyList();
        Assert.assertEquals((String)"Full list shouldn't equal empty", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        list2 = Arrays.asList(this.getOtherElements());
        Assert.assertEquals((String)"Full list shouldn't equal other", (boolean)false, (boolean)list.equals(list2));
        this.verify();
        list2 = Arrays.asList(this.getFullElements());
        if (list2.size() < 2 && this.isAddSupported()) {
            list.addAll(Arrays.asList(this.getOtherElements()));
            this.confirmed.addAll(Arrays.asList(this.getOtherElements()));
            list2 = new ArrayList<Object>(list2);
            list2.addAll(Arrays.asList(this.getOtherElements()));
        }
        if (list2.size() > 1) {
            Collections.reverse(list2);
            Assert.assertEquals((String)"Full list shouldn't equal full list with same elements but different order", (boolean)false, (boolean)list.equals(list2));
            this.verify();
        }
        this.resetFull();
        list = this.getList();
        Assert.assertEquals((String)"List shouldn't equal String", (boolean)false, (boolean)list.equals(""));
        this.verify();
        final List<Object> listForC = Arrays.asList(this.getFullElements());
        AbstractCollection c = new AbstractCollection(){

            public int size() {
                return listForC.size();
            }

            public Iterator iterator() {
                return listForC.iterator();
            }
        };
        Assert.assertEquals((String)"List shouldn't equal nonlist with same elements in same order", (boolean)false, (boolean)list.equals(c));
        this.verify();
    }

    public void testListHashCode() {
        this.resetEmpty();
        int hash1 = this.collection.hashCode();
        int hash2 = this.confirmed.hashCode();
        Assert.assertEquals((String)"Empty lists should have equal hashCodes", (int)hash1, (int)hash2);
        this.verify();
        this.resetFull();
        hash1 = this.collection.hashCode();
        hash2 = this.confirmed.hashCode();
        Assert.assertEquals((String)"Full lists should have equal hashCodes", (int)hash1, (int)hash2);
        this.verify();
    }

    public void testListGetByIndex() {
        this.resetFull();
        List list = this.getList();
        Object[] elements = this.getFullElements();
        int i = 0;
        while (i < elements.length) {
            Assert.assertEquals((String)"List should contain correct elements", (Object)elements[i], list.get(i));
            this.verify();
            ++i;
        }
    }

    public void testListGetByIndexBoundsChecking() {
        List list = this.makeEmptyList();
        try {
            list.get(Integer.MIN_VALUE);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(-1);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(0);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [0]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(1);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(Integer.MAX_VALUE);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListGetByIndexBoundsChecking2() {
        List list = this.makeFullList();
        try {
            list.get(Integer.MIN_VALUE);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(-1);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(this.getFullElements().length);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [size]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.get(Integer.MAX_VALUE);
            Assert.fail((String)"List.get should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListIndexOf() {
        this.resetFull();
        List list1 = this.getList();
        List list2 = this.getConfirmedList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            Assert.assertEquals((String)"indexOf should return correct result", (int)list1.indexOf(element), (int)list2.indexOf(element));
            this.verify();
        }
        Object[] other = this.getOtherElements();
        int i = 0;
        while (i < other.length) {
            Assert.assertEquals((String)"indexOf should return -1 for nonexistent element", (int)list1.indexOf(other[i]), (int)-1);
            this.verify();
            ++i;
        }
    }

    public void testListLastIndexOf() {
        this.resetFull();
        List list1 = this.getList();
        List list2 = this.getConfirmedList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            Assert.assertEquals((String)"lastIndexOf should return correct result", (int)list1.lastIndexOf(element), (int)list2.lastIndexOf(element));
            this.verify();
        }
        Object[] other = this.getOtherElements();
        int i = 0;
        while (i < other.length) {
            Assert.assertEquals((String)"lastIndexOf should return -1 for nonexistent element", (int)list1.lastIndexOf(other[i]), (int)-1);
            this.verify();
            ++i;
        }
    }

    public void testListSetByIndexBoundsChecking() {
        if (!this.isSetSupported()) {
            return;
        }
        List list = this.makeEmptyList();
        Object element = this.getOtherElements()[0];
        try {
            list.set(Integer.MIN_VALUE, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(-1, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(0, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [0]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(1, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(Integer.MAX_VALUE, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListSetByIndexBoundsChecking2() {
        if (!this.isSetSupported()) {
            return;
        }
        List list = this.makeFullList();
        Object element = this.getOtherElements()[0];
        try {
            list.set(Integer.MIN_VALUE, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(-1, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(this.getFullElements().length, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [size]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.set(Integer.MAX_VALUE, element);
            Assert.fail((String)"List.set should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListSetByIndex() {
        if (!this.isSetSupported()) {
            return;
        }
        this.resetFull();
        Object[] elements = this.getFullElements();
        Object[] other = this.getOtherElements();
        int i = 0;
        while (i < elements.length) {
            Object n = other[i % other.length];
            Object v = ((List)this.collection).set(i, n);
            Assert.assertEquals((String)"Set should return correct element", (Object)elements[i], (Object)v);
            ((List)this.confirmed).set(i, n);
            this.verify();
            ++i;
        }
    }

    public void testUnsupportedSet() {
        if (this.isSetSupported()) {
            return;
        }
        this.resetFull();
        try {
            ((List)this.collection).set(0, new Object());
            Assert.fail((String)"Emtpy collection should not support set.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.verify();
    }

    public void testListRemoveByIndexBoundsChecking() {
        if (!this.isRemoveSupported()) {
            return;
        }
        List list = this.makeEmptyList();
        try {
            list.remove(Integer.MIN_VALUE);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(-1);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(0);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [0]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(1);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(Integer.MAX_VALUE);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListRemoveByIndexBoundsChecking2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        List list = this.makeFullList();
        try {
            list.remove(Integer.MIN_VALUE);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(-1);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [-1]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(this.getFullElements().length);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [size]");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            list.remove(Integer.MAX_VALUE);
            Assert.fail((String)"List.remove should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testListRemoveByIndex() {
        if (!this.isRemoveSupported()) {
            return;
        }
        int max = this.getFullElements().length;
        int i = 0;
        while (i < max) {
            this.resetFull();
            Object o1 = ((List)this.collection).remove(i);
            Object o2 = ((List)this.confirmed).remove(i);
            Assert.assertEquals((String)"remove should return correct element", o1, o2);
            this.verify();
            ++i;
        }
    }

    public void testListListIterator() {
        this.resetFull();
        this.forwardTest(this.getList().listIterator(), 0);
        this.backwardTest(this.getList().listIterator(), 0);
    }

    public void testListListIteratorByIndex() {
        this.resetFull();
        try {
            this.getList().listIterator(-1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        try {
            this.getList().listIterator(this.getList().size() + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.resetFull();
        int i = 0;
        while (i <= this.confirmed.size()) {
            this.forwardTest(this.getList().listIterator(i), i);
            this.backwardTest(this.getList().listIterator(i), i);
            ++i;
        }
        this.resetFull();
        int i2 = 0;
        while (i2 <= this.confirmed.size()) {
            this.backwardTest(this.getList().listIterator(i2), i2);
            ++i2;
        }
    }

    public void testListListIteratorPreviousRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        ListIterator it = this.getList().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Object two2 = it.previous();
        Object one2 = it.previous();
        Assert.assertSame(one, one2);
        Assert.assertSame(two, two2);
        Assert.assertSame(zero, this.getList().get(0));
        Assert.assertSame(one, this.getList().get(1));
        Assert.assertSame(two, this.getList().get(2));
        it.remove();
        Assert.assertSame(zero, this.getList().get(0));
        Assert.assertSame(two, this.getList().get(1));
    }

    private void forwardTest(ListIterator iter, int i) {
        List list = this.getList();
        int max = this.getFullElements().length;
        while (i < max) {
            Assert.assertTrue((String)"Iterator should have next", (boolean)iter.hasNext());
            Assert.assertEquals((String)"Iterator.nextIndex should work", (int)iter.nextIndex(), (int)i);
            Assert.assertEquals((String)"Iterator.previousIndex should work", (int)iter.previousIndex(), (int)(i - 1));
            Object o = iter.next();
            Assert.assertEquals((String)"Iterator returned correct element", list.get(i), o);
            ++i;
        }
        Assert.assertTrue((String)"Iterator shouldn't have next", (!iter.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((String)"nextIndex should be size", (int)iter.nextIndex(), (int)max);
        Assert.assertEquals((String)"previousIndex should be size - 1", (int)iter.previousIndex(), (int)(max - 1));
        try {
            iter.next();
            Assert.fail((String)"Exhausted iterator should raise NoSuchElement");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    private void backwardTest(ListIterator iter, int i) {
        List list = this.getList();
        while (i > 0) {
            Assert.assertTrue((String)("Iterator should have previous, i:" + i), (boolean)iter.hasPrevious());
            Assert.assertEquals((String)("Iterator.nextIndex should work, i:" + i), (int)iter.nextIndex(), (int)i);
            Assert.assertEquals((String)("Iterator.previousIndex should work, i:" + i), (int)iter.previousIndex(), (int)(i - 1));
            Object o = iter.previous();
            Assert.assertEquals((String)"Iterator returned correct element", list.get(i - 1), o);
            --i;
        }
        Assert.assertTrue((String)"Iterator shouldn't have previous", (!iter.hasPrevious() ? 1 : 0) != 0);
        int nextIndex = iter.nextIndex();
        Assert.assertEquals((String)("nextIndex should be 0, actual value: " + nextIndex), (int)nextIndex, (int)0);
        int prevIndex = iter.previousIndex();
        Assert.assertEquals((String)("previousIndex should be -1, actual value: " + prevIndex), (int)prevIndex, (int)-1);
        try {
            iter.previous();
            Assert.fail((String)"Exhausted iterator should raise NoSuchElement");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testListIteratorAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        List list1 = this.getList();
        List list2 = this.getConfirmedList();
        Object[] elements = this.getFullElements();
        ListIterator<Object> iter1 = list1.listIterator();
        ListIterator<Object> iter2 = list2.listIterator();
        int i = 0;
        while (i < elements.length) {
            iter1.add(elements[i]);
            iter2.add(elements[i]);
            this.verify();
            ++i;
        }
        this.resetFull();
        iter1 = this.getList().listIterator();
        iter2 = this.getConfirmedList().listIterator();
        int i2 = 0;
        while (i2 < elements.length) {
            iter1.next();
            iter2.next();
            iter1.add(elements[i2]);
            iter2.add(elements[i2]);
            this.verify();
            ++i2;
        }
    }

    public void testListIteratorSet() {
        if (!this.isSetSupported()) {
            return;
        }
        Object[] elements = this.getFullElements();
        this.resetFull();
        ListIterator<Object> iter1 = this.getList().listIterator();
        ListIterator<Object> iter2 = this.getConfirmedList().listIterator();
        int i = 0;
        while (i < elements.length) {
            iter1.next();
            iter2.next();
            iter1.set(elements[i]);
            iter2.set(elements[i]);
            this.verify();
            ++i;
        }
    }

    public void testEmptyListSerialization() throws IOException, ClassNotFoundException {
        List list = this.makeEmptyList();
        if (!(list instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)((Object)list));
        List list2 = (List)this.readExternalFormFromBytes(objekt);
        Assert.assertTrue((String)"Both lists are empty", (list.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Both lists are empty", (list2.size() == 0 ? 1 : 0) != 0);
    }

    public void testFullListSerialization() throws IOException, ClassNotFoundException {
        List list = this.makeFullList();
        int size = this.getFullElements().length;
        if (!(list instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)((Object)list));
        List list2 = (List)this.readExternalFormFromBytes(objekt);
        Assert.assertEquals((String)"Both lists are same size", (int)list.size(), (int)size);
        Assert.assertEquals((String)"Both lists are same size", (int)list2.size(), (int)size);
    }

    public void testEmptyListCompatibility() throws IOException, ClassNotFoundException {
        List list = this.makeEmptyList();
        if (list instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            List list2 = (List)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(list));
            Assert.assertTrue((String)"List is empty", (list2.size() == 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)list, (Object)list2);
        }
    }

    public void testFullListCompatibility() throws IOException, ClassNotFoundException {
        List list = this.makeFullList();
        if (list instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            List list2 = (List)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(list));
            if (list2.size() == 4) {
                return;
            }
            Assert.assertEquals((String)"List is the right size", (int)list.size(), (int)list2.size());
            Assert.assertEquals((Object)list, (Object)list2);
        }
    }

    public BulkTest bulkTestSubList() {
        if (this.getFullElements().length - 6 < 10) {
            return null;
        }
        return new BulkTestSubList(this);
    }

    public void testListSubListFailFastOnAdd() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (!this.isAddSupported()) {
            return;
        }
        this.resetFull();
        int size = this.collection.size();
        List sub = this.getList().subList(1, size);
        this.getList().add(this.getOtherElements()[0]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().add(0, this.getOtherElements()[0]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().addAll(Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().addAll(0, Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
    }

    public void testListSubListFailFastOnRemove() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.collection.size();
        List sub = this.getList().subList(1, size);
        this.getList().remove(0);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().remove(this.getFullElements()[2]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().removeAll(Arrays.asList(this.getFullElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().retainAll(Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getList().subList(1, size);
        this.getList().clear();
        this.failFastAll(sub);
    }

    protected void failFastAll(List list) {
        Method[] methods = (class$java$util$List == null ? (class$java$util$List = AbstractTestList.class$("java.util.List")) : class$java$util$List).getMethods();
        int i = 0;
        while (i < methods.length) {
            this.failFastMethod(list, methods[i]);
            ++i;
        }
    }

    protected void failFastMethod(List list, Method m) {
        if (m.getName().equals("equals")) {
            return;
        }
        Object element = this.getOtherElements()[0];
        Set<Object> c = Collections.singleton(element);
        Class<?>[] types = m.getParameterTypes();
        Object[] params = new Object[types.length];
        int i = 0;
        while (i < params.length) {
            if (types[i] == Integer.TYPE) {
                params[i] = new Integer(0);
            } else if (types[i] == (class$java$util$Collection == null ? AbstractTestList.class$("java.util.Collection") : class$java$util$Collection)) {
                params[i] = c;
            } else if (types[i] == (class$java$lang$Object == null ? AbstractTestList.class$("java.lang.Object") : class$java$lang$Object)) {
                params[i] = element;
            } else if (types[i] == (array$Ljava$lang$Object == null ? AbstractTestList.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object)) {
                params[i] = new Object[0];
            }
            ++i;
        }
        try {
            m.invoke((Object)list, params);
            Assert.fail((String)(m.getName() + " should raise ConcurrentModification"));
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ConcurrentModificationException) {
                return;
            }
            Assert.fail((String)(m.getName() + " raised unexpected " + e));
        }
    }

    public BulkTest bulkTestListIterator() {
        return new TestListIterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TestListIterator
    extends AbstractTestListIterator {
        public TestListIterator() {
            super("TestListIterator");
        }

        public Object addSetValue() {
            return AbstractTestList.this.getOtherElements()[0];
        }

        public boolean supportsRemove() {
            return AbstractTestList.this.isRemoveSupported();
        }

        public boolean supportsAdd() {
            return AbstractTestList.this.isAddSupported();
        }

        public boolean supportsSet() {
            return AbstractTestList.this.isSetSupported();
        }

        public ListIterator makeEmptyListIterator() {
            AbstractTestList.this.resetEmpty();
            return ((List)AbstractTestList.this.collection).listIterator();
        }

        public ListIterator makeFullListIterator() {
            AbstractTestList.this.resetFull();
            return ((List)AbstractTestList.this.collection).listIterator();
        }
    }

    public static class BulkTestSubList
    extends AbstractTestList {
        private AbstractTestList outer;

        BulkTestSubList(AbstractTestList outer) {
            super("");
            this.outer = outer;
        }

        public Object[] getFullElements() {
            List<Object> l = Arrays.asList(this.outer.getFullElements());
            return l.subList(3, l.size() - 3).toArray();
        }

        public Object[] getOtherElements() {
            return this.outer.getOtherElements();
        }

        public boolean isAddSupported() {
            return this.outer.isAddSupported();
        }

        public boolean isSetSupported() {
            return this.outer.isSetSupported();
        }

        public boolean isRemoveSupported() {
            return this.outer.isRemoveSupported();
        }

        public List makeEmptyList() {
            return this.outer.makeFullList().subList(4, 4);
        }

        public List makeFullList() {
            int size = this.getFullElements().length;
            return this.outer.makeFullList().subList(3, size - 3);
        }

        public void resetEmpty() {
            this.outer.resetFull();
            this.collection = this.outer.getList().subList(4, 4);
            this.confirmed = this.outer.getConfirmedList().subList(4, 4);
        }

        public void resetFull() {
            this.outer.resetFull();
            int size = this.outer.confirmed.size();
            this.collection = this.outer.getList().subList(3, size - 3);
            this.confirmed = this.outer.getConfirmedList().subList(3, size - 3);
        }

        public void verify() {
            super.verify();
            this.outer.verify();
        }

        public boolean isTestSerialization() {
            return false;
        }
    }
}

