#define _GNU_SOURCE
#define DEST "tmp⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊"

#include "ch_time_and_mod.h"
#include "ch_time_and_mod_dir.h"
#include "filefrag_custom.h"
#include "global.h"
#include "md5.h"
#include "verify_hash.h"
#include "xmalloc.h" //inline

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <linux/limits.h>
#include <linux/falloc.h>

char *write_now;

static char *buf;
static char *md5hash;

#define FALLOC_MISS \
{\
	if(close(ifrom) == -1)\
	{\
		perror("close");\
	}\
\
	if(close(ito) == -1)\
	{\
		perror("close");\
	}\
\
	if(unlink(DEST) == -1)\
	{\
		perror("unlink");\
	}\
\
	printf("スキップ : (%d) %s\n", from_extents, src);\
	fflush(stdout);\
\
	write_now = DEST;\
\
	return;\
}

static void do_rename(const char *src, const struct stat *stat_from);

/*******************************************************************************
*******************************************************************************/
void do_rename(const char *src, const struct stat *stat_from)
{
	if(rename(DEST, src) == -1)
	{
		perror("rename");

		if(unlink(DEST) == -1)
		{
			perror("unlink");
		}
	}
	else
	{
		int i;
		if((i = open(src, O_RDONLY)) != -1)
		{
			ch_time_and_mod(i, src, stat_from);

			if(close(i) == -1)
			{
				perror("close");
			}

			if((stat_target_directory != NULL) && (stat_data != NULL))
			{
				ch_time_and_mod_dir(stat_target_directory, stat_data);
			}
		}
	}
}

/*******************************************************************************
*******************************************************************************/
void cp(const char *src, const int from_extents)
{
	if(buf == NULL)
	{
		buf = xmalloc(BUF_SIZE);
	}

	int ifrom = open(src, O_RDONLY | O_NOATIME | O_NOFOLLOW);

	if(ifrom == -1)
	{
		switch(errno)
		{
		case EPERM:
			errno = 0;

			if((ifrom = open(src, O_RDONLY)) == -1)
			{
				perror("open");
				return;
			}
			break;

		default:
			perror("open");
			return;
			break;
		}
	}

	struct stat stat_from;
	fstat(ifrom, &stat_from);

	_Bool flag_size_check = false;

	if(flag_gigabyte == false)
	{
		if(stat_from.st_size >= 1024 * 1024 * 1024)
		{
			flag_size_check = true;
		}
	}

	if(flag_over_gigabyte == true)
	{
		if(stat_from.st_size < 1024 * 1024 * 1024)
		{
			flag_size_check = true;
		}
	}

	if(flag_size_check == true)
	{
		if(close(ifrom) == -1)
		{
			perror("close");
		}

		return;
	}

	int ito = open(DEST, O_WRONLY | O_CREAT, S_IRWXU);

	if(ito == -1)
	{
		if(close(ifrom) == -1)
		{
			perror("close");
		}

		return;
	}

	if((stat_target_directory != NULL) && (stat_data != NULL))
	{
		ch_time_and_mod_dir(stat_target_directory, stat_data);
	}

	write_now = DEST;

	int to_extents = INT_MAX;
	_Bool file_alloc_posix = false;

	/* Ubuntu 11.04だとfallocateの第二引数は FALLOC_FL_KEEP_SIZE と FALLOC_FL_PUNCH_HOLE の二つ。linux/falloc.h のincludeが必要。 */
	if(fallocate(ito, FALLOC_FL_KEEP_SIZE, 0, stat_from.st_size) == -1)
	{
		perror("fallocate");

		int p_f_r;

		if((p_f_r = posix_fallocate(ito, 0, stat_from.st_size)) != 0)
		{
			errno = p_f_r;
			perror("posix_fallocate");
		}
		else
		{
			file_alloc_posix = true;
		}
	}
	else
	{
		_Bool file_alloc = false;
		int i = 1;

		while(1)
		{
			to_extents = filefrag_custom(DEST);

			if(from_extents <= to_extents)
			{
				if(ftruncate(ito, 0) == -1)
				{
					perror("ftruncate");
				}
			}
			else
			{
				file_alloc = true;
				break;
			}

			/* ループの回数に深い意味は無い。 */
			if(i > 255)
			{
				break;
			}
			else if(flag_advance == false)
			{
				break;
			}

			if(fallocate(ito, FALLOC_FL_KEEP_SIZE, 0, stat_from.st_size) == -1)
			{
				perror("fallocate");
				break;
			}
			else
			{
				i++;
			}
		}

		if(file_alloc == false)
		{
			FALLOC_MISS
		}
	}


	if(file_alloc_posix == true)
	{
		to_extents = filefrag_custom(DEST);

		if(from_extents <= to_extents)
		{
			FALLOC_MISS
		}
	}

	md5_state_t state;
	md5_byte_t digest[16];

	if(flag_verify == true)
	{
		md5_init(&state);

		if(md5hash == NULL)
		{
			md5hash = xmalloc((16 * 2) + 1);
		}
		else
		{
			md5hash[0] = '\0';
		}
	}

	{
		printf("デフラグ中 : (%d) %s -> ", from_extents, src);
		fflush(stdout);

		int i = 0;
		char *p;
		char *endp;
		ssize_t b;

		while((i = read(ifrom, buf, BUF_SIZE)) > 0)
		{
			p = buf;
			endp = buf + i;

			while(p < endp)
			{
				b = write(ito, p, endp - p);
				p += b;
			}

			if(flag_verify == true)
			{
				md5_append(&state, (md5_byte_t *)buf, i);
			}
		}
	}

	if(flag_verify == true)
	{
		md5_finish(&state, digest);

		for(int di = 0; di < 16; ++di)
		{
			sprintf(md5hash + di * 2, "%02x", digest[di]);
		}
	}

	struct stat stat_to;
	fstat(ifrom, &stat_from);
	fstat(ito, &stat_to);

	if(ftruncate(ito, stat_from.st_size) == -1)
	{
		perror("ftruncate");
	}

	if(fdatasync(ito) == -1)
	{
		perror("fdatasync");
	}

	if(close(ifrom) == -1)
	{
		perror("close");
	}

	if(close(ito) == -1)
	{
		perror("close");
	}

	_Bool ch_flag = false;

	if(stat_from.st_size == stat_to.st_size)
	{
		int i;
		if((i = open(src, O_RDONLY)) != -1)
		{
			ch_time_and_mod(i, DEST, &stat_from);

			if(close(i) == -1)
			{
				perror("close");
			}
		}

		ch_flag = true;
	}

	_Bool b = false;

	if(flag_verify == true)
	{
		b = verify_hash(DEST, stat_to.st_size, md5hash);
	}

	if((b == true) && (ch_flag == true) && (from_extents > to_extents))
	{
		do_rename(src, &stat_from);
		printf("(%d)\n", to_extents);
		fflush(stdout);
	}
	else if((flag_verify == false) && (ch_flag == true) && (from_extents > to_extents))
	{
		do_rename(src, &stat_from);
		printf("(%d)\n", to_extents);
		fflush(stdout);
	}
	else
	{
		if(unlink(DEST) == -1)
		{
			perror("unlink");
		}

		printf("(%d)\n", from_extents);
		fflush(stdout);
	}

	write_now = NULL;
}
