#include <stdio.h>

#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <utime.h>

/*******************************************************************************
*******************************************************************************/
void ch_time_and_mod_dir(const char *file_path, const struct stat *stat_buf)
{
	static struct utimbuf times;
	errno = 0;

	if(chmod(file_path, stat_buf->st_mode) == -1)
	{
		fprintf(stderr, "%s\n", file_path);
		perror("chmod");
	}

	if(chown(file_path, stat_buf->st_uid, stat_buf->st_gid) == -1)
	{
		fprintf(stderr, "%s\n", file_path);
		perror("chown");
	}

	times.actime  = stat_buf->st_atime;
	times.modtime = stat_buf->st_mtime;

	if(utime(file_path, &times) == -1)
	{
		fprintf(stderr, "%s\n", file_path);
		perror("utime");
	}
}
