/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.f77editorplugin.editor.ui.action;

import jp.sourceforge.f77editorplugin.editor.ui.FortranEditor;
import jp.sourceforge.f77editorplugin.editor.ui.action.EditorActionDelegate;
import jp.sourceforge.f77editorplugin.text.detectors.CommentLineDetector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public class ToggleCommentAction
extends EditorActionDelegate {
    private static final String COMMENT_LETTER = "c";
    private CommentLineDetector commentDetector = new CommentLineDetector();

    @Override
    public void run(IAction action) {
        IEditorPart editor = this.getActiveEditor();
        if (editor instanceof FortranEditor) {
            FortranEditor fortranEditor = (FortranEditor)editor;
            try {
                TextSelection selection = (TextSelection)this.getSelection();
                if (selection != null && selection.getLength() > 0) {
                    this.toggleCommentWithSelection(selection);
                } else {
                    this.toggleCommentWithoutSelection(fortranEditor.getCaretOffset());
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void toggleCommentWithoutSelection(int caretOffset) throws BadLocationException {
        IDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        int line = doc.getLineOfOffset(caretOffset);
        String str = doc.get(doc.getLineOffset(line), doc.getLineLength(line));
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        if (this.commentDetector.isLinePart((CharSequence)str)) {
            multiTextEdit.addChild((TextEdit)new ReplaceEdit(doc.getLineOffset(line), 1, ""));
        } else {
            multiTextEdit.addChild((TextEdit)new InsertEdit(doc.getLineOffset(line), COMMENT_LETTER));
        }
        multiTextEdit.apply(doc);
    }

    private void toggleCommentWithSelection(TextSelection selection) throws BadLocationException {
        IDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        int offset = doc.getLineOffset(startLine);
        int length = doc.getLineOffset(endLine) + doc.getLineLength(endLine) - offset;
        boolean isCommentOnly = true;
        int line = startLine;
        while (line < endLine + 1) {
            String str = doc.get(doc.getLineOffset(line), doc.getLineLength(line));
            if (!this.commentDetector.isLinePart((CharSequence)str)) {
                isCommentOnly = false;
                break;
            }
            ++line;
        }
        StringBuffer buf = new StringBuffer();
        int line2 = startLine;
        while (line2 < endLine + 1) {
            if (isCommentOnly) {
                buf.append(doc.get(doc.getLineOffset(line2), doc.getLineLength(line2)).substring(1));
            } else {
                buf.append(COMMENT_LETTER + doc.get(doc.getLineOffset(line2), doc.getLineLength(line2)));
            }
            ++line2;
        }
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        multiTextEdit.addChild((TextEdit)new ReplaceEdit(offset, length, buf.toString()));
        multiTextEdit.apply(doc);
        int selectionLength = doc.getLineOffset(endLine) + doc.getLineLength(endLine) - doc.getLineOffset(startLine);
        this.setSelection(doc.getLineOffset(startLine), selectionLength);
    }

    @Override
    public boolean isEnabled(ISelection selection) {
        return selection instanceof TextSelection;
    }
}

